/*
 * Decompiled with CFR 0.152.
 */
package com.github.easydoc.param;

import com.github.easydoc.sourcebrowser.FisheyeSourceBrowser;
import com.github.easydoc.sourcebrowser.GithubSourceBrowser;
import com.github.easydoc.sourcebrowser.SourceBrowser;
import java.util.EnumSet;

public class SourceBrowserParam {
    private String baseUrl;
    private Type type;
    private int revision;

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl + (baseUrl.endsWith("/") ? "" : "/");
    }

    public Type getType() {
        return this.type;
    }

    public void setType(String stype) {
        this.type = Type.fromString(stype);
    }

    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    public String toString() {
        return String.format("SourceBrowserParam [baseUrl=%s, type=%s]", new Object[]{this.baseUrl, this.type});
    }

    public static enum Type {
        GITHUB(GithubSourceBrowser.class),
        FISHEYE(FisheyeSourceBrowser.class);

        private final Class<? extends SourceBrowser> sbcls;

        private Type(Class<? extends SourceBrowser> sbcls) {
            this.sbcls = sbcls;
        }

        public Class<? extends SourceBrowser> getSourceBrowserClass() {
            return this.sbcls;
        }

        public static Type fromString(String s) {
            for (Type entry : EnumSet.allOf(Type.class)) {
                if (!s.equalsIgnoreCase(entry.toString())) continue;
                return entry;
            }
            throw new IllegalArgumentException("Unknown source browser type: " + s);
        }
    }
}

