/*
 * Decompiled with CFR 0.152.
 */
package com.github.easydoc.semantics.directiverule;

import com.github.easydoc.model.Directive;
import com.github.easydoc.model.Doc;
import com.github.easydoc.model.Model;
import com.github.easydoc.model.criteria.DocSearchCriteria;
import com.github.easydoc.semantics.NegativeValidationResult;
import com.github.easydoc.semantics.PositiveValidationResult;
import com.github.easydoc.semantics.ValidationResult;
import com.github.easydoc.semantics.directiverule.DirectiveRule;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class IncludeDirectiveRule
implements DirectiveRule {
    @Override
    public Set<String> getRequiredParams() {
        return Collections.singleton("id");
    }

    @Override
    public ValidationResult validate(Directive directive, Doc doc, Model model) {
        final String idValue = directive.getParams().get("id");
        if (doc.getParams().containsKey("id") && idValue.equals(doc.getParams().get("id"))) {
            return new NegativeValidationResult(String.format("The doc cannot include itself ('include' directive id and doc id are the same, '%s')", idValue));
        }
        List<Doc> result = model.findDocs(new DocSearchCriteria(){

            @Override
            public boolean satisfies(Doc item) {
                return item.getParams().containsKey("id") && idValue.equals(item.getParams().get("id"));
            }
        });
        if (result.size() < 1) {
            return new NegativeValidationResult(String.format("Trying to include the doc '%s', which has not been found.", idValue));
        }
        return new PositiveValidationResult(result.get(0));
    }

    @Override
    public void run(Directive directive, Doc doc, Model model, ValidationResult result) {
        directive.setText(((Doc)result.getData()).getText());
    }
}

