/*
 * Decompiled with CFR 0.152.
 */
package com.github.easydoc.semantics.methods;

import com.github.easydoc.model.Doc;
import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IndexTextMethod
implements TemplateMethodModelEx {
    private static final int maxIndexTextLength = 50;

    public Object exec(List arguments) throws TemplateModelException {
        if (arguments.size() != 1) {
            throw new TemplateModelException("indexText: invalid arguments: " + arguments);
        }
        Object arg1 = arguments.get(0);
        try {
            Doc doc = (Doc)((StringModel)arg1).getWrappedObject();
            String text = doc.getText().trim();
            int eolInd = text.indexOf("\n");
            String ret = eolInd > 0 ? text.substring(0, eolInd) : text;
            ret = this.extractSimpleString(ret.trim());
            if (ret.length() <= 50) {
                return ret;
            }
            return null;
        }
        catch (ClassCastException e) {
            throw new TemplateModelException("indexText: invalid arguments: " + arguments, (Exception)e);
        }
    }

    private String extractSimpleString(String htmlString) {
        Pattern pattern = Pattern.compile("^<h[1-5]>(.+)</h[1-5]>");
        Matcher matcher = pattern.matcher(htmlString);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return htmlString;
    }
}

