/*
 * Decompiled with CFR 0.152.
 */
package com.github.easydoc.semantics.paramrule;

import com.github.easydoc.model.Doc;
import com.github.easydoc.model.Model;
import com.github.easydoc.semantics.NegativeValidationResult;
import com.github.easydoc.semantics.PositiveValidationResult;
import com.github.easydoc.semantics.ValidationResult;
import com.github.easydoc.semantics.paramrule.ParamRule;
import com.petebevin.markdown.MarkdownProcessor;
import java.util.EnumSet;

public class FormatParamRule
implements ParamRule {
    private MarkdownProcessor markdown = new MarkdownProcessor();

    @Override
    public boolean requiresValue() {
        return true;
    }

    @Override
    public ValidationResult validate(String value, Doc doc, Model model) {
        for (Format f : EnumSet.allOf(Format.class)) {
            if (!f.toString().equalsIgnoreCase(value)) continue;
            return new PositiveValidationResult((Object)f);
        }
        return new NegativeValidationResult("Unknown/unsupported format: '" + value + "'");
    }

    @Override
    public void run(String value, Doc doc, Model model, ValidationResult validationResult) {
        Format format = (Format)((Object)validationResult.getData());
        switch (format) {
            case MARKDOWN: {
                doc.setText(this.markdown.markdown(doc.getText()));
            }
        }
    }

    private static enum Format {
        HTML,
        MARKDOWN;

    }
}

