/*
 * Decompiled with CFR 0.152.
 */
package com.github.easydoc.sourcebrowser;

import com.github.easydoc.model.Doc;
import com.github.easydoc.model.SourceLink;
import com.github.easydoc.param.SourceBrowserParam;
import com.github.easydoc.sourcebrowser.SourceBrowser;
import java.net.MalformedURLException;
import java.net.URL;

public class GithubSourceBrowser
implements SourceBrowser {
    private final String baseUrl;

    public GithubSourceBrowser(SourceBrowserParam sbParam) {
        this.baseUrl = sbParam.getBaseUrl();
    }

    @Override
    public URL generateUrl(Doc doc) {
        try {
            SourceLink sourceLink = doc.getSourceLink();
            return new URL(String.format("%s%s#L%d-%d", this.baseUrl, sourceLink.getFile().getPath(), sourceLink.getStartLine(), sourceLink.getEndLine()));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

