<#macro generateDoc doc>
	<!-- Generated from ${doc.sourceLink.file.path}:${doc.sourceLink.startLine} -->
	<p>
		<#if doc.id??>
			<a name="${doc.id}"></a>
		</#if>
		${doc.text}
		<#if sourceBrowser??>
			<p>
				<a class="easydoc-source-link" 
					href="${sourceBrowser.generateUrl(doc)}" 
					target="_blank">source</a>
			</p>
		</#if>
	</p>
</#macro>

<#macro generateDocTree docTree>
	<#list docTree as doc>
		<@generateDoc doc=doc/>
		<#if doc.children??>
			<@generateDocTree docTree=doc.children/>
		</#if>
	</#list>
</#macro>

<#macro generateDocIndex docTree>
	<ul class="easydoc-index">
		<#list docTree as doc>
			<#if doc.id??>
				<li><a href="#${doc.id}">${indexText(doc)}</a></li>
			</#if>
			<#if doc.hasChildrenWithIds()>
				<li>
					<@generateDocIndex docTree=doc.children/>
				</li>
			</#if>
		</#list>
	</ul>
</#macro>

<html>
	<head>
		<meta http-equiv="content-type" content="text/html; charset=${encoding}">
		<#if projectName??>
			<title>Easydoc Maven Plugin documentation</title>
		<#else>
			<title>Documentation</title>
		</#if>
		
		<#if css??>
			<style>
				${css}
			</style>
		</#if>
	</head>
	
	<body>
		<#if generateIndex>
			<p>
				<@generateDocIndex docTree=doctree/>
			</p>
		</#if>
		
		<@generateDocTree docTree=doctree/>
		
		<div class="easydoc-footer">
			Generated by <a href="https://github.com/weekens/easydoc">Easydoc</a> 
			version ${version}.
		</div>
	</body>
</html>