/*
 * Decompiled with CFR 0.152.
 */
package com.shixin.dal.dao;

import cn.hutool.core.lang.Assert;
import com.shixin.commons.util.BeanUtil;
import com.shixin.dal.dao.BaseDao;
import com.shixin.dal.entity.BaseEntity;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.repository.NoRepositoryBean;

@NoRepositoryBean
public abstract class BaseDaoImpl<R extends JpaRepository<T, Integer>, T extends BaseEntity>
implements BaseDao<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseDaoImpl.class);
    @Autowired
    protected R repository;

    @Override
    public T create(T t) {
        Assert.notNull(t, (String)"\u5f85\u521b\u5efa\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isNull((Object)((BaseEntity)t).getId(), (String)"\u5f85\u521b\u5efa\u7684\u5bf9\u8c61Id\u5fc5\u987b\u4e3a\u7a7a", (Object[])new Object[0]);
        return (T)((BaseEntity)this.repository.saveAndFlush(t));
    }

    @Override
    public List<T> createAll(List<T> list) {
        Assert.notEmpty(list, (String)"\u5f85\u521b\u5efa\u5bf9\u8c61\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.repository.saveAll(list);
    }

    @Override
    public T update(T t) {
        Assert.notNull(t, (String)"\u5f85\u66f4\u65b0\u5bf9\u8c61{}\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)((BaseEntity)t).getId(), (String)"\u5f85\u66f4\u65b0\u5bf9\u8c61Id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BaseEntity toUpdate = (BaseEntity)this.repository.getOne((Object)((BaseEntity)t).getId());
        BeanUtil.copy(t, (Object)toUpdate);
        return (T)((BaseEntity)this.repository.save((Object)toUpdate));
    }

    @Override
    public T updateWithNull(T t) {
        Assert.notNull(t, (String)"\u5f85\u66f4\u65b0\u5bf9\u8c61{}\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)((BaseEntity)t).getId(), (String)"\u5f85\u66f4\u65b0\u5bf9\u8c61Id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BaseEntity toUpdate = (BaseEntity)this.repository.getOne((Object)((BaseEntity)t).getId());
        BeanUtil.copyWithNull(t, (Object)toUpdate);
        return (T)((BaseEntity)this.repository.save((Object)toUpdate));
    }

    @Override
    public T findById(Integer id) {
        Assert.notNull((Object)id, (String)"\u67e5\u8be2Id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (T)((BaseEntity)this.repository.findById((Object)id).filter(obj -> Objects.nonNull(obj.getDeleted()) && obj.getDeleted() == false).orElse(null));
    }

    @Override
    public void deleteById(Integer id) {
        Assert.notNull((Object)id, (String)"\u5220\u9664Id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BaseEntity toDelete = (BaseEntity)this.repository.getOne((Object)id);
        toDelete.setDeleted(null);
        this.repository.save((Object)toDelete);
    }

    @Override
    public void delete(T t) {
        Assert.notNull((Object)((BaseEntity)t).getId(), (String)"\u5220\u9664ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        T toDelete = this.findOne(t);
        Assert.notNull(toDelete, (String)"\u5220\u9664\u5bf9\u8c61\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        ((BaseEntity)toDelete).setDeleted(null);
        this.repository.save(toDelete);
    }

    @Override
    public Page<T> pageQuery(T t, Pageable pageable) {
        return this.repository.findAll(Example.of(t), pageable);
    }

    @Override
    public T findOne(T t) {
        return (T)((BaseEntity)this.repository.findOne(Example.of(t)).orElse(null));
    }

    @Override
    public List<T> findAll(T t) {
        return this.repository.findAll(Example.of(t));
    }

    @Override
    public List<T> findAll() {
        return this.repository.findAll();
    }
}

