/*
 * Decompiled with CFR 0.152.
 */
package com.github.mybatis.crud.condition;

import com.github.mybatis.crud.structure.CommonFunction;
import org.springframework.util.Assert;

public interface Like<C>
extends CommonFunction<C> {
    public static final String SYMBOL = "like";

    default public C andLikeDiy(String field, String likeString) {
        return this.createWhere(false, "and", field, SYMBOL, likeString, "ESCAPE '/'", false);
    }

    default public C likeDiy(String field, String likeString) {
        return this.andLikeDiy(field, likeString);
    }

    default public C andLike(String field, Object value) {
        Assert.isTrue((value instanceof Number || value instanceof String ? 1 : 0) != 0, (String)"like only supports Number and String: ".concat(field));
        return this.createWhere(false, "and", field, SYMBOL, "%".concat(this.handleLikeEscape(value)).concat("%"), "ESCAPE '/'", false);
    }

    default public C andLike(String field) {
        this.canUseLike(field);
        return this.createWhere(false, "and", field, SYMBOL, "concat('%', concat(".concat(this.preFillParmFormat(field)).concat(", '%'))"), "ESCAPE '/'", true);
    }

    default public C like(String field, Object value) {
        return this.andLike(field, value);
    }

    default public C like(String field) {
        return this.andLike(field);
    }

    default public C andLeftLike(String field, Object value) {
        Assert.isTrue((value instanceof Number || value instanceof String ? 1 : 0) != 0, (String)"like only supports Number and String: ".concat(field));
        return this.createWhere(false, "and", field, SYMBOL, "%".concat(this.handleLikeEscape(value)), "ESCAPE '/'", false);
    }

    default public C andLeftLike(String field) {
        this.canUseLike(field);
        return this.createWhere(false, "and", field, SYMBOL, "concat('%', ".concat(this.preFillParmFormat(field)).concat(")"), "ESCAPE '/'", true);
    }

    default public C lLike(String field, Object value) {
        return this.andLeftLike(field, value);
    }

    default public C lLike(String field) {
        return this.andLeftLike(field);
    }

    default public C andRightLike(String field, Object value) {
        Assert.isTrue((value instanceof Number || value instanceof String ? 1 : 0) != 0, (String)"like only supports Number and String: ".concat(field));
        return this.createWhere(false, "and", field, SYMBOL, this.handleLikeEscape(value).concat("%"), "ESCAPE '/'", false);
    }

    default public C andRightLike(String field) {
        this.canUseLike(field);
        return this.createWhere(false, "and", field, SYMBOL, "concat(" + this.preFillParmFormat(field) + ", ".concat("'%'").concat(")"), "ESCAPE '/'", true);
    }

    default public C rLike(String field, Object value) {
        return this.andRightLike(field, value);
    }

    default public C rLike(String field) {
        return this.andRightLike(field);
    }

    default public C orLikeDiy(String field, String likeString) {
        return this.createWhere(false, "or", field, SYMBOL, likeString, "ESCAPE '/'", false);
    }

    default public C orLike(String field, Object value) {
        Assert.isTrue((value instanceof Number || value instanceof String ? 1 : 0) != 0, (String)"like only supports Number and String: ".concat(field));
        return this.createWhere(false, "or", field, SYMBOL, "%".concat(this.handleLikeEscape(value)).concat("%"), "ESCAPE '/'", false);
    }

    default public C orLike(String field) {
        this.canUseLike(field);
        return this.createWhere(false, "or", field, SYMBOL, "concat('%', concat(".concat(this.preFillParmFormat(field)).concat(", '%'))"), "ESCAPE '/'", true);
    }

    default public C orLeftLike(String field, Object value) {
        Assert.isTrue((value instanceof Number || value instanceof String ? 1 : 0) != 0, (String)"like only supports Number and String: ".concat(field));
        return this.createWhere(false, "or", field, SYMBOL, "%".concat(this.handleLikeEscape(value)), "ESCAPE '/'", false);
    }

    default public C orLeftLike(String field) {
        this.canUseLike(field);
        return this.createWhere(false, "or", field, SYMBOL, "concat('%', ".concat(this.preFillParmFormat(field)).concat(")"), "ESCAPE '/'", true);
    }

    default public C orLLike(String field, Object value) {
        return this.orLeftLike(field, value);
    }

    default public C orLLike(String field) {
        return this.orLeftLike(field);
    }

    default public C orRightLike(String field, Object value) {
        Assert.isTrue((value instanceof Number || value instanceof String ? 1 : 0) != 0, (String)"like only supports Number and String: ".concat(field));
        return this.createWhere(false, "or", field, SYMBOL, this.handleLikeEscape(value).concat("%"), "ESCAPE '/'", false);
    }

    default public C orRightLike(String field) {
        this.canUseLike(field);
        return this.createWhere(false, "or", field, SYMBOL, "concat(" + this.preFillParmFormat(field) + ", ".concat("'%'").concat(")"), "ESCAPE '/'", true);
    }

    default public C orRLike(String field, Object value) {
        return this.orRightLike(field, value);
    }

    default public C orRLike(String field) {
        return this.orRightLike(field);
    }
}

