/*
 * Decompiled with CFR 0.152.
 */
package com.github.mybatis.crud.handler;

import com.github.mybatis.crud.handler.DeleteMybatisInterceptorHandler;
import com.github.mybatis.crud.structure.Condition;
import com.github.mybatis.crud.structure.Where;
import com.github.mybatis.crud.util.ReflectionUtil;
import com.github.mybatis.crud.util.StringUtil;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.ibatis.plugin.Invocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LikeEscapeHandler
implements DeleteMybatisInterceptorHandler {
    private static final Logger log = LoggerFactory.getLogger(LikeEscapeHandler.class);

    @Override
    public void before(Invocation invocation) {
        Object[] args = invocation.getArgs();
        Object parameter = args[1];
        if (parameter instanceof Condition) {
            Condition condition = new Condition((Condition)parameter);
            List<Where> wheres = condition.getWheres();
            for (Where where : wheres) {
                if (!"like".equalsIgnoreCase(where.getSymbol()) || !where.getIsPre().booleanValue()) continue;
                log.debug("like \u8f6c\u4e49 ->");
                this.handlePre(condition, where);
            }
            args[1] = condition;
        }
    }

    private void handlePre(Condition condition, Where where) {
        String likeColumn = where.getColumn();
        Field likeField = ReflectionUtil.findField(condition.getEntity().getClass(), (String)likeColumn);
        if (String.class.equals(likeField.getType())) {
            ReflectionUtil.makeAccessible((Field)likeField);
            String value = (String)ReflectionUtil.getField((Field)likeField, condition.getEntity());
            if (StringUtil.isBlank(value)) {
                return;
            }
            value = value.replaceAll("/", "//");
            value = value.replaceAll("_", "/_");
            value = value.replaceAll("%", "/%");
            ReflectionUtil.setField((Field)likeField, condition.getEntity(), (Object)value);
            log.debug("\u66f4\u65b0\u5217{},\u503c\u4e3a{}", (Object)likeColumn, (Object)value);
        }
    }
}

