/*
 * Decompiled with CFR 0.152.
 */
package com.github.mybatis.crud.helper;

import com.github.mybatis.crud.cache.CacheData;
import com.github.mybatis.crud.structure.AbstractCondition;
import com.github.mybatis.crud.structure.Condition;
import com.github.mybatis.crud.structure.Left;
import com.github.mybatis.crud.structure.OnCondition;
import com.github.mybatis.crud.structure.Pair;
import com.github.mybatis.crud.structure.Right;
import com.github.mybatis.crud.structure.Where;
import com.github.mybatis.crud.structure.WhereCondition;
import com.github.mybatis.crud.util.ReflectionUtil;
import com.github.mybatis.crud.util.StringUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqlHelper {
    private static final Logger log = LoggerFactory.getLogger(SqlHelper.class);

    public static <E> String buildWhere(Condition<E> condition) {
        Object entity = condition.getEntity();
        StringBuffer sql = new StringBuffer();
        sql.append(" WHERE ");
        Object whereBuffer = null;
        for (Where where : condition.getWheres()) {
            sql.append(SqlHelper.buildByWhereForSignTable(where, null, condition, "condition", "entity"));
        }
        return sql.toString();
    }

    public static String camelToUnderscore(String fieldName) {
        String underscore = (String)CacheData.camelAndUnderscore.get(fieldName);
        if (StringUtil.isNotBlank(underscore)) {
            return underscore;
        }
        underscore = StringUtil.camelToUnderscore(fieldName, "LOWER_CAMEL", "LOWER_UNDERSCORE");
        CacheData.camelAndUnderscore.put(fieldName, underscore);
        return underscore;
    }

    public static String buildOn(OnCondition condition, Map<Class<?>, Pair<String, String>> tableAlias, String conditionParamName) {
        Object entity = condition.getEntity();
        Object entity2 = condition.getEntity2();
        StringBuffer sql = new StringBuffer();
        Object whereBuffer = null;
        for (Where where : condition.getWhereList()) {
            boolean isDiyJoinWhere;
            boolean isMultipleTableWhere = where.getLeft() != null && where.getRight() != null;
            boolean isSignTableWhere = !isMultipleTableWhere && (where.getColumn() != null || where.getSymbol() != null || where.getValue() != null);
            boolean bl = isDiyJoinWhere = !isMultipleTableWhere && !isSignTableWhere && where != null;
            if (isDiyJoinWhere) {
                sql.append(SqlHelper.buildByWhereForDiyJoin(where));
                continue;
            }
            if (isSignTableWhere) {
                sql.append(SqlHelper.buildByWhereForSignTable(where, tableAlias.get(entity.getClass()).getSecond(), condition, conditionParamName, "entity"));
                continue;
            }
            sql.append(SqlHelper.buildByWhereForMultipleTable(where, tableAlias));
        }
        return sql.toString();
    }

    public static String buildWhere(WhereCondition condition, Map<Class<?>, Pair<String, String>> tableAlias, String conditionParamName) {
        Object entity = condition.getEntity();
        Object entity2 = condition.getEntity2();
        StringBuffer sql = new StringBuffer();
        Object whereBuffer = null;
        for (Where where : condition.getWhereList()) {
            boolean isDiyJoinWhere;
            boolean isMultipleTableWhere = where.getLeft() != null && where.getRight() != null;
            boolean isSignTableWhere = !isMultipleTableWhere && (where.getColumn() != null || where.getSymbol() != null || where.getValue() != null);
            boolean bl = isDiyJoinWhere = !isMultipleTableWhere && !isSignTableWhere && where != null;
            if (isDiyJoinWhere) {
                sql.append(SqlHelper.buildByWhereForDiyJoin(where));
                continue;
            }
            if (isSignTableWhere) {
                sql.append(SqlHelper.buildByWhereForSignTable(where, tableAlias.get(entity.getClass()).getSecond(), condition, conditionParamName, "entity"));
                continue;
            }
            sql.append(SqlHelper.buildByWhereForMultipleTable(where, tableAlias));
        }
        return sql.toString();
    }

    private static <C extends AbstractCondition> String buildByWhereForDiyJoin(Where where) {
        StringBuffer whereBuffer = new StringBuffer(" ");
        whereBuffer.append(StringUtil.defaultEmptyIfBlank(where.getStart())).append(" ").append(StringUtil.defaultEmptyIfBlank(where.getJoin())).append(" ").append(StringUtil.defaultEmptyIfBlank(where.getEnd())).append(" ");
        return whereBuffer.toString();
    }

    private static <C extends AbstractCondition> String buildByWhereForSignTable(Where where, String tableAlias, C condition, String conditionParamName, String entityParamName) {
        StringBuffer whereBuffer = new StringBuffer(" ");
        String underscore = SqlHelper.camelToUnderscore(StringUtil.defaultEmptyIfBlank(where.getColumn()));
        whereBuffer.append(StringUtil.defaultEmptyIfBlank(where.getStart())).append(" ").append(StringUtil.defaultEmptyIfBlank(where.getJoin())).append(" ").append(StringUtil.isNotBlank(tableAlias) ? tableAlias.concat(".") : "").append(StringUtil.defaultEmptyIfBlank(underscore)).append(" ").append(StringUtil.defaultEmptyIfBlank(where.getSymbol())).append(" ");
        if (where.getValue() != null) {
            if (where.getValue() instanceof Number) {
                whereBuffer.append(where.getValue());
            } else if (where.getValue() instanceof String) {
                if (where.getIsPre().booleanValue()) {
                    whereBuffer.append(where.getValue());
                } else {
                    whereBuffer.append("'").append(where.getValue()).append("'");
                }
            } else if (where.getValue() instanceof List) {
                if (Arrays.asList("in (", "not in (").contains(where.getSymbol())) {
                    whereBuffer.append(StringUtil.join((List)where.getValue(), ","));
                } else if (Arrays.asList("between", "not between").contains(where.getSymbol())) {
                    List list = (List)where.getValue();
                    if (list.get(0) instanceof Number) {
                        whereBuffer.append(list.get(0)).append(" and ").append(list.get(1));
                    } else {
                        Map<String, Object> param = condition.getParam();
                        String start = where.getColumn().concat("BetweenStart");
                        String end = where.getColumn().concat("BetweenEnd");
                        int index = 0;
                        while (param.containsKey(start) && param.containsKey(end)) {
                            start = start + ++index;
                            end = end + index;
                        }
                        param.put(start, list.get(0));
                        param.put(end, list.get(1));
                        condition.setParam(param);
                        whereBuffer.append("#{").append(conditionParamName).append(".param.").append(start).append("}").append(" and ").append("#{").append(conditionParamName).append(".param.").append(end).append("}");
                    }
                }
            } else {
                Field field = ReflectionUtil.findField(condition.getEntity().getClass(), (String)where.getColumn());
                ReflectionUtil.makeAccessible((Field)field);
                ReflectionUtil.setField((Field)field, condition.getEntity(), (Object)where.getValue());
                whereBuffer.append("#{").append(conditionParamName).append(".").append(entityParamName).append(".").append(where.getColumn()).append("}");
            }
        }
        whereBuffer.append(" ").append(StringUtil.defaultEmptyIfBlank(where.getEnd())).append(" ");
        return whereBuffer.toString();
    }

    private static String buildByWhereForMultipleTable(Where where, Map<Class<?>, Pair<String, String>> tableAlias) {
        StringBuffer whereBuffer = new StringBuffer(" ");
        whereBuffer.append(StringUtil.defaultEmptyIfBlank(where.getStart())).append(" ").append(StringUtil.defaultEmptyIfBlank(where.getJoin())).append(" ");
        Left leftTable = where.getLeft();
        Right rightTable = where.getRight();
        whereBuffer.append(tableAlias.get(leftTable.getFirst()).getSecond()).append(".").append(SqlHelper.camelToUnderscore((String)leftTable.getSecond())).append(where.getSymbol()).append(tableAlias.get(rightTable.getFirst()).getSecond()).append(".").append(SqlHelper.camelToUnderscore((String)rightTable.getSecond()));
        whereBuffer.append(" ").append(StringUtil.defaultEmptyIfBlank(where.getEnd())).append(" ");
        return whereBuffer.toString();
    }

    private SqlHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

