/*
 * Decompiled with CFR 0.152.
 */
package com.github.mybatis.crud.interceptor;

import com.github.mybatis.crud.handler.DefaultMybatisInterceptorHandler;
import com.github.mybatis.crud.handler.DeleteMybatisInterceptorHandler;
import com.github.mybatis.crud.handler.IdSetHandler;
import com.github.mybatis.crud.handler.InsertMybatisInterceptorHandler;
import com.github.mybatis.crud.handler.PrepareMybatisInterceptorHandler;
import com.github.mybatis.crud.handler.SelectMybatisInterceptorHandler;
import com.github.mybatis.crud.handler.UpdateMybatisInterceptorHandler;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class DefaultMybatisInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DefaultMybatisInterceptor.class);
    private static List<DefaultMybatisInterceptorHandler> pluginHandlers = new ArrayList<IdSetHandler>(Arrays.asList(new IdSetHandler()));

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object target = invocation.getTarget();
        Object[] args = invocation.getArgs();
        if (target instanceof Executor) {
            MappedStatement ms = (MappedStatement)args[0];
            Object parameter = args[1];
            BoundSql boundSql = ms.getBoundSql(parameter);
            String sql = boundSql.getSql();
            String name = ms.getId();
            System.out.println("\u62e6\u622a\u7684\u65b9\u6cd5\u540d\u662f:" + name + ",sql\u662f\uff1a" + sql + ",\u53c2\u6570\u662f\uff1a" + parameter);
            if (ms.getSqlCommandType() == SqlCommandType.SELECT) {
                log.debug("\u67e5\u8be2");
                for (int i = 0; i < pluginHandlers.size(); ++i) {
                    if (!(pluginHandlers.get(i) instanceof SelectMybatisInterceptorHandler)) continue;
                    pluginHandlers.get(i).before(invocation);
                }
            } else if (ms.getSqlCommandType() == SqlCommandType.INSERT) {
                log.debug("\u63d2\u5165");
                for (int i = 0; i < pluginHandlers.size(); ++i) {
                    if (!(pluginHandlers.get(i) instanceof InsertMybatisInterceptorHandler)) continue;
                    pluginHandlers.get(i).before(invocation);
                }
            } else if (ms.getSqlCommandType() == SqlCommandType.DELETE) {
                log.debug("\u5220\u9664");
                for (int i = 0; i < pluginHandlers.size(); ++i) {
                    if (!(pluginHandlers.get(i) instanceof DeleteMybatisInterceptorHandler)) continue;
                    pluginHandlers.get(i).before(invocation);
                }
            } else if (ms.getSqlCommandType() == SqlCommandType.UPDATE) {
                log.debug("\u66f4\u65b0");
                for (int i = 0; i < pluginHandlers.size(); ++i) {
                    if (!(pluginHandlers.get(i) instanceof UpdateMybatisInterceptorHandler)) continue;
                    pluginHandlers.get(i).before(invocation);
                }
            }
        } else {
            log.debug("prepare");
            for (int i = 0; i < pluginHandlers.size(); ++i) {
                if (!(pluginHandlers.get(i) instanceof PrepareMybatisInterceptorHandler)) continue;
                pluginHandlers.get(i).before(invocation);
            }
        }
        Object returnObject = invocation.proceed();
        return returnObject;
    }

    public void setPluginHandlers(DefaultMybatisInterceptorHandler ... defaultMybatisInterceptorHandler) {
        pluginHandlers.addAll(Arrays.asList(defaultMybatisInterceptorHandler));
    }

    public static List<DefaultMybatisInterceptorHandler> getPluginHandlers() {
        return Collections.unmodifiableList(pluginHandlers);
    }
}

