/*
 * Decompiled with CFR 0.152.
 */
package com.github.mybatis.crud.provider;

import com.github.mybatis.crud.helper.SqlHelper;
import com.github.mybatis.crud.structure.Three;
import com.github.mybatis.crud.util.EntityUtil;
import com.github.mybatis.crud.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInsertProvider<E> {
    private static final Logger log = LoggerFactory.getLogger(DefaultInsertProvider.class);
    private String tableName;
    private String sequence;
    private Three<String, Object, Class> idNameAndValue;

    public String insert(E entity) {
        this.initValue(entity);
        List<String> fields = EntityUtil.getAllFieldName(entity, StringUtil.isNotBlank(this.sequence) ? Arrays.asList(this.idNameAndValue.getFirst()) : new ArrayList(), StringUtil.isNotBlank(this.sequence) ? null : this.idNameAndValue.getFirst());
        return this.buildOneSql(fields);
    }

    public String insertSelective(E entity) {
        this.initValue(entity);
        List<String> fields = EntityUtil.getAllHaveValueFieldName(entity, StringUtil.isNotBlank(this.sequence) ? Arrays.asList(this.idNameAndValue.getFirst()) : new ArrayList(), StringUtil.isNotBlank(this.sequence) ? null : this.idNameAndValue.getFirst());
        return this.buildOneSql(fields);
    }

    public String batchInsert(List<E> list) {
        this.initValue(list.get(0));
        List<String> fields = EntityUtil.getAllFieldName(list.get(0), StringUtil.isNotBlank(this.sequence) ? Arrays.asList(this.idNameAndValue.getFirst()) : new ArrayList(), StringUtil.isNotBlank(this.sequence) ? null : this.idNameAndValue.getFirst());
        return this.buildBatchSql(list.size(), fields);
    }

    public String batchInsertSelective(List<E> list) {
        this.initValue(list.get(0));
        List<String> fields = EntityUtil.getAllHaveValueFieldName(list.get(0), StringUtil.isNotBlank(this.sequence) ? Arrays.asList(this.idNameAndValue.getFirst()) : new ArrayList(), StringUtil.isNotBlank(this.sequence) ? null : this.idNameAndValue.getFirst());
        return this.buildBatchSql(list.size(), fields);
    }

    private void initValue(E entity) {
        this.tableName = EntityUtil.getTableName(entity);
        Map<String, Object> idAnnotationValue = EntityUtil.getIdAnnotationValue(entity);
        this.sequence = (String)idAnnotationValue.get("sequence");
        this.idNameAndValue = EntityUtil.getIdNameAndValueAndType(entity);
    }

    private String buildOneSql(final List<String> fields) {
        return new SQL(){
            {
                this.INSERT_INTO(DefaultInsertProvider.this.tableName);
                for (String field : fields) {
                    this.VALUES(SqlHelper.camelToUnderscore(field), "#{".concat(field).concat("}"));
                }
            }
        }.toString();
    }

    private String buildBatchSql(int length, List<String> fields) {
        StringBuffer sql = new StringBuffer();
        if (StringUtil.isNotBlank(this.sequence)) {
            sql.append("begin ").append(new SQL().INSERT_INTO(this.tableName));
            sql.append(" ( ").append(this.buildColumn(fields, true, "", "")).append(" ) ");
            sql.append(new SQL(){
                {
                    this.SELECT(DefaultInsertProvider.this.sequence.concat(".nextval ").concat(SqlHelper.camelToUnderscore((String)DefaultInsertProvider.this.idNameAndValue.getFirst())));
                    this.SELECT("A.*");
                }
            }.toString());
            sql.append(" FROM (");
            for (int i = 0; i < length; ++i) {
                sql.append(" SELECT ");
                sql.append(this.buildColumn(fields, false, "#{list[" + i + "].", "}"));
                sql.append(" FROM dual ");
                if (i >= length - 1) continue;
                sql.append("UNION ALL");
            }
            sql.append(" )A; end;");
        } else {
            sql.append(new SQL().INSERT_INTO(this.tableName));
            sql.append(" ( ").append(this.buildColumn(fields, true, "", "")).append(" ) ");
            sql.append("VALUES ");
            for (int i = 0; i < length; ++i) {
                sql.append("(").append(this.buildColumn(fields, false, "#{list[" + i + "].", "}")).append(")");
                if (i >= length - 1) continue;
                sql.append(",");
            }
        }
        return sql.toString();
    }

    private String buildColumn(List<String> fields, boolean isCovert, String prefix, String suffix) {
        StringBuffer column = new StringBuffer();
        for (String field : fields) {
            if (!isCovert && StringUtil.isNotBlank(this.sequence)) {
                if (this.idNameAndValue.getFirst().equals(field)) continue;
                column.append(prefix).append(isCovert ? SqlHelper.camelToUnderscore(field) : field).append(suffix).append(" ").append(SqlHelper.camelToUnderscore(field)).append(",");
                continue;
            }
            column.append(prefix).append(isCovert ? SqlHelper.camelToUnderscore(field) : field).append(suffix).append(",");
        }
        return column.deleteCharAt(column.length() - 1).toString();
    }
}

