/*
 * Decompiled with CFR 0.152.
 */
package com.github.mybatis.crud.provider;

import com.github.mybatis.crud.helper.SqlHelper;
import com.github.mybatis.crud.structure.As;
import com.github.mybatis.crud.structure.Condition;
import com.github.mybatis.crud.structure.Left;
import com.github.mybatis.crud.structure.LeftJoin;
import com.github.mybatis.crud.structure.OnCondition;
import com.github.mybatis.crud.structure.Pair;
import com.github.mybatis.crud.structure.Right;
import com.github.mybatis.crud.structure.Select;
import com.github.mybatis.crud.structure.Three;
import com.github.mybatis.crud.structure.Where;
import com.github.mybatis.crud.structure.WhereCondition;
import com.github.mybatis.crud.util.EntityUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.jdbc.SQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class DefaultSelectProvider<E> {
    private static final Logger log = LoggerFactory.getLogger(DefaultSelectProvider.class);
    private String tableName;
    private Three<String, Object, Class> idNameAndValue;

    public String selectByPrimaryKey(E entity) {
        this.initValue(entity);
        return this.buildSql(EntityUtil.getAllFieldName(entity, null, new String[0]));
    }

    public String list(Condition<E> condition) {
        Assert.isTrue((condition.getWheres() != null && condition.getWheres().size() > 0 ? 1 : 0) != 0, (String)"where can not be null");
        this.initValue(condition.getEntity());
        StringBuffer sql = new StringBuffer("SELECT ");
        sql.append(this.buildColumn(EntityUtil.getAllFieldName(condition.getEntity(), null, new String[0])));
        sql.append(" FROM ").append(this.tableName);
        sql.append(SqlHelper.buildWhere(condition));
        return sql.toString();
    }

    public String select(Select<E> select) {
        Assert.isTrue((select != null ? 1 : 0) != 0, (String)"select can not be null");
        log.debug("select >>>>>");
        return ((SQL)((SQL)((SQL)((SQL)new SQL().SELECT("employee.*")).FROM("employee")).LEFT_OUTER_JOIN("user_info on user_info.employee_id = employee.id")).WHERE("1=1")).toString();
    }

    public String leftJoin(LeftJoin<E> leftJoin) {
        Assert.isTrue((leftJoin != null ? 1 : 0) != 0, (String)"leftJoin can not be null");
        log.debug("leftJoin >>>>>");
        HashMap tableAlias = new HashMap(2);
        int index = 0;
        for (Class<?> entityClass : leftJoin.getEntityClass()) {
            String tableName = EntityUtil.getTableName(EntityUtil.instance(entityClass));
            String alias = "T" + index++;
            tableAlias.put(entityClass, Pair.of(tableName, alias));
        }
        StringBuffer sql = new StringBuffer("SELECT ");
        Set<As> fields = leftJoin.getFields();
        int i = 0;
        for (As as : fields) {
            sql.append((String)((Pair)tableAlias.get(as.getFirst())).getSecond()).append(".").append(SqlHelper.camelToUnderscore((String)as.getSecond())).append(" ").append((String)as.getThree());
            if (i < fields.size() - 1) {
                sql.append(",");
            }
            ++i;
        }
        sql.append(" FROM ");
        String fromTable = EntityUtil.getTableName(leftJoin.getEntity());
        Class<?> mainEntityClass = leftJoin.getEntity().getClass();
        sql.append(fromTable).append(" ").append((String)((Pair)tableAlias.get(mainEntityClass)).getSecond());
        Where on = leftJoin.getOnConditions().get(0).getWheres().get(0);
        Left leftTable = on.getLeft();
        Right rightTable = on.getRight();
        Class joinEntityClass = ((Class)leftTable.getFirst()).equals(mainEntityClass) ? (Class)rightTable.getFirst() : (Class)leftTable.getFirst();
        sql.append(" LEFT JOIN ");
        sql.append((String)((Pair)tableAlias.get(joinEntityClass)).getFirst()).append(" ").append((String)((Pair)tableAlias.get(joinEntityClass)).getSecond());
        sql.append(" On ");
        sql.append((String)((Pair)tableAlias.get(leftTable.getFirst())).getSecond()).append(".").append(SqlHelper.camelToUnderscore((String)leftTable.getSecond()));
        sql.append(on.getSymbol());
        sql.append((String)((Pair)tableAlias.get(rightTable.getFirst())).getSecond()).append(".").append(SqlHelper.camelToUnderscore((String)rightTable.getSecond()));
        OnCondition onCondition = null;
        for (int j = 1; j < leftJoin.getOnConditions().size(); ++j) {
            onCondition = leftJoin.getOnConditions().get(j);
            sql.append(SqlHelper.buildOn(onCondition, tableAlias, "onConditions[" + j + "]"));
        }
        if (leftJoin.getWhereConditions().size() > 0) {
            sql.append(" WHERE 1=1 ");
            WhereCondition whereCondition = null;
            for (int j = 0; j < leftJoin.getWhereConditions().size(); ++j) {
                whereCondition = leftJoin.getWhereConditions().get(j);
                sql.append(SqlHelper.buildWhere(whereCondition, tableAlias, "whereConditions[" + j + "]"));
            }
        }
        return sql.toString();
    }

    public String leftJoins(LeftJoin<E> ... leftJoin) {
        return null;
    }

    private void initValue(E entity) {
        this.tableName = EntityUtil.getTableName(entity);
        this.idNameAndValue = EntityUtil.getIdNameAndValueAndType(entity);
    }

    private String buildSql(List<String> fields) {
        StringBuffer sql = new StringBuffer("SELECT ");
        sql.append(this.buildColumn(fields));
        sql.append(" FROM ").append(this.tableName);
        sql.append(" WHERE ").append(SqlHelper.camelToUnderscore(this.idNameAndValue.getFirst())).append("=").append("#{").append(this.idNameAndValue.getFirst()).append("}");
        return sql.toString();
    }

    private String buildColumn(List<String> fields) {
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < fields.size(); ++i) {
            sql.append(SqlHelper.camelToUnderscore(fields.get(i))).append(" ").append(fields.get(i));
            if (i >= fields.size() - 1) continue;
            sql.append(",");
        }
        return sql.toString();
    }
}

