/*
 * Decompiled with CFR 0.152.
 */
package com.github.mybatis.crud.provider;

import com.github.mybatis.crud.helper.SqlHelper;
import com.github.mybatis.crud.structure.Three;
import com.github.mybatis.crud.structure.Update;
import com.github.mybatis.crud.util.EntityUtil;
import com.github.mybatis.crud.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class DefaultUpdateProvider<E> {
    private static final Logger log = LoggerFactory.getLogger(DefaultUpdateProvider.class);
    private String tableName;
    private Three<String, Object, Class> idNameAndValue;

    public String updateByPrimaryKey(E entity) {
        this.initValue(entity);
        return this.buildSql(EntityUtil.getAllFieldName(entity, null, this.idNameAndValue.getFirst()));
    }

    public String updateByPrimaryKeySelective(E entity) {
        this.initValue(entity);
        return this.buildSql(EntityUtil.getAllHaveValueFieldName(entity, null, this.idNameAndValue.getFirst()));
    }

    public String updateField(Map dataMap) {
        Object entity = dataMap.get("entity");
        String[] fields = (String[])dataMap.get("fields");
        Assert.isTrue((fields != null && fields.length > 0 ? 1 : 0) != 0, (String)"update fields can not be null");
        this.initValue(entity);
        return this.buildSql(Arrays.asList(fields), "entity");
    }

    public String update(Update<E> update) {
        boolean isFieldsNotNull = update.getFields() != null && update.getFields().size() > 0;
        Assert.isTrue((update.getIsUpdateSelective() != null || isFieldsNotNull ? 1 : 0) != 0, (String)"update fields cannot be null when isUpdateSelective is null");
        this.initValue(update.getCondition().getEntity());
        StringBuffer sql = new StringBuffer(((SQL)new SQL().UPDATE(this.tableName)).toString());
        if (isFieldsNotNull) {
            sql.append(this.buildSet(update.getFields(), "condition.entity"));
        } else if (update.getIsUpdateSelective().booleanValue()) {
            sql.append(this.buildSet(EntityUtil.getAllHaveValueFieldName(update.getCondition().getEntity(), null, this.idNameAndValue.getFirst()), "condition.entity"));
        } else {
            sql.append(this.buildSet(EntityUtil.getAllFieldName(update.getCondition().getEntity(), null, this.idNameAndValue.getFirst()), "condition.entity"));
        }
        sql.append(SqlHelper.buildWhere(update.getCondition()));
        return sql.toString();
    }

    private void initValue(E entity) {
        this.tableName = EntityUtil.getTableName(entity);
        this.idNameAndValue = EntityUtil.getIdNameAndValueAndType(entity);
    }

    private String buildSql(List<String> fields, String prefix) {
        StringBuffer sql = new StringBuffer(((SQL)new SQL().UPDATE(this.tableName)).toString());
        sql.append(this.buildSet(fields, prefix));
        sql.append(" WHERE ");
        sql.append(SqlHelper.camelToUnderscore(this.idNameAndValue.getFirst())).append("=").append("#{").append(StringUtil.isNotBlank(prefix) ? prefix + "." : "").append(this.idNameAndValue.getFirst()).append("}");
        return sql.toString();
    }

    private String buildSql(List<String> fields) {
        return this.buildSql(fields, null);
    }

    private String buildSet(List<String> fields, String prefix) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SET ");
        for (int i = 0; i < fields.size(); ++i) {
            sql.append(SqlHelper.camelToUnderscore(fields.get(i))).append("=").append("#{").append(StringUtil.isNotBlank(prefix) ? prefix + "." : "").append(fields.get(i)).append("}");
            if (i >= fields.size() - 1) continue;
            sql.append(",");
        }
        return sql.toString();
    }
}

