/*
 * Decompiled with CFR 0.152.
 */
package com.github.mybatis.crud.structure;

import com.github.mybatis.crud.handler.DefaultMybatisInterceptorHandler;
import com.github.mybatis.crud.handler.LikeEscapeHandler;
import com.github.mybatis.crud.interceptor.DefaultMybatisInterceptor;
import com.github.mybatis.crud.structure.Pair;
import com.github.mybatis.crud.structure.Where;
import java.util.Arrays;
import java.util.List;
import org.springframework.util.Assert;

public interface CommonFunction<C> {
    public List<Where> getWhereList();

    public List<Pair<String, Class>> getFieldTypeList();

    public C getCondition();

    public Boolean getIsJoinByMethod();

    default public void checkType(String field, Object value) {
        Assert.isTrue((value != null ? 1 : 0) != 0, (String)"condition value can not be null: ".concat(field));
        if (value instanceof List) {
            boolean isNotNullList = true;
            for (Object object : (List)value) {
                if (object != null) continue;
                isNotNullList = false;
                break;
            }
            Assert.isTrue((boolean)isNotNullList, (String)"condition value cannot contain null values: ".concat(field));
        }
        boolean flag = false;
        for (Pair pair : this.getFieldTypeList()) {
            if (!((String)pair.getFirst()).equals(field)) continue;
            if (value.getClass().equals(pair.getSecond())) {
                flag = true;
                break;
            }
            if (!(value instanceof List) || ((List)value).isEmpty() || !((List)value).get(0).getClass().equals(pair.getSecond())) continue;
            flag = true;
            break;
        }
        Assert.isTrue((boolean)flag, (String)"condition with field type does not match: ".concat(field));
    }

    default public void canUseLike(String field) {
        boolean flag = false;
        for (Pair<String, Class> nameType : this.getFieldTypeList()) {
            if (!nameType.getFirst().equals(field) || !String.class.equals((Object)nameType.getSecond()) && !Number.class.isAssignableFrom(nameType.getSecond())) continue;
            flag = true;
            break;
        }
        Assert.isTrue((boolean)flag, (String)"like only supports Number and String: ".concat(field));
    }

    default public boolean isJoin() {
        Where where;
        if (this.getIsJoinByMethod().booleanValue()) {
            return true;
        }
        return this.getWhereList().size() > 0 && (")".equals((where = this.getWhereList().get(this.getWhereList().size() - 1)).getEnd()) || where.getValue() != null || Arrays.asList("is null", "is not null").contains(where.getSymbol()));
    }

    default public C createWhere(boolean checkType, String join, String column, String symbol, Object value, Boolean isPre) {
        return this.createWhere(checkType, join, column, symbol, value, null, isPre);
    }

    default public C createWhere(boolean checkType, String join, String column, String symbol, Object value, String end, Boolean isPre) {
        if (checkType) {
            this.checkType(column, value);
        }
        if (!this.isJoin()) {
            join = "";
        }
        this.getWhereList().add(Where.builder().join(join).column(column).symbol(symbol).value(value).end(end).isPre(isPre).build());
        return this.getCondition();
    }

    default public String preFillParmFormat(String field) {
        return "#{condition.entity.".concat(field).concat("}");
    }

    default public String handleLikeEscape(Object value) {
        if (value instanceof Number) {
            return String.valueOf(value);
        }
        List<DefaultMybatisInterceptorHandler> pluginHandlers = DefaultMybatisInterceptor.getPluginHandlers();
        for (DefaultMybatisInterceptorHandler handler : pluginHandlers) {
            if (!(handler instanceof LikeEscapeHandler)) continue;
            String escapeValue = (String)value;
            escapeValue = escapeValue.replaceAll("/", "//");
            escapeValue = escapeValue.replaceAll("_", "/_");
            escapeValue = escapeValue.replaceAll("%", "/%");
            return escapeValue;
        }
        return (String)value;
    }
}

