/*
 * Decompiled with CFR 0.152.
 */
package com.github.mybatis.crud.structure;

import com.github.mybatis.crud.structure.AbstractCondition;
import com.github.mybatis.crud.structure.DefaultCondition;
import com.github.mybatis.crud.structure.Pair;
import com.github.mybatis.crud.structure.Where;
import com.github.mybatis.crud.util.EntityUtil;
import java.util.List;
import java.util.function.Consumer;

public class Condition<E>
extends AbstractCondition<E, Condition<E>>
implements DefaultCondition<Condition<E>> {
    public Condition(Class<E> eClass) {
        super(eClass);
    }

    public Condition(E entity) {
        super(entity);
    }

    public Condition(Condition<E> source) {
        super(source);
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public static <E> Builder<E> builder(Class<E> eClass) {
        return new Builder<Class<E>>(eClass);
    }

    public static <E> Builder<E> builder(E entity) {
        return new Builder<E>(entity);
    }

    @Override
    public List<Where> getWhereList() {
        return this.getWheres();
    }

    @Override
    public List<Pair<String, Class>> getFieldTypeList() {
        return this.getFieldTypes();
    }

    @Override
    public Condition<E> getCondition() {
        return this;
    }

    @Override
    public Boolean getIsJoinByMethod() {
        return false;
    }

    public Condition<E> group(Consumer<Condition<E>> consumer) {
        this.getWheres().add(Where.builder().start("(").build());
        consumer.accept(this);
        this.getWheres().add(Where.builder().end(")").build());
        return this;
    }

    public Condition<E> and(Consumer<Condition<E>> consumer) {
        if (this.isJoin()) {
            this.getWheres().add(Where.builder().join("and").build());
        }
        return this.group(consumer);
    }

    public Condition<E> or(Consumer<Condition<E>> consumer) {
        if (this.isJoin()) {
            this.getWheres().add(Where.builder().join("or").build());
        }
        return this.group(consumer);
    }

    public String toString() {
        return "Condition()";
    }

    public static class Builder<E> {
        private E entity;

        Builder() {
        }

        Builder(Class<E> eClass) {
            this.entity = EntityUtil.instance(eClass);
        }

        Builder(E entity) {
            this.entity = entity;
        }

        public Builder entity(Class<E> eClass) {
            this.entity = EntityUtil.instance(eClass);
            return this;
        }

        public Builder entity(E entity) {
            this.entity = entity;
            return this;
        }

        public Condition<E> build() {
            return new Condition<E>(this.entity);
        }
    }
}

