/*
 * Decompiled with CFR 0.152.
 */
package com.github.mybatis.crud.structure;

import com.github.mybatis.crud.structure.As;
import com.github.mybatis.crud.structure.Left;
import com.github.mybatis.crud.structure.On;
import com.github.mybatis.crud.structure.OnCondition;
import com.github.mybatis.crud.structure.Right;
import com.github.mybatis.crud.structure.WhereCondition;
import com.github.mybatis.crud.util.EntityUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LeftJoin<E> {
    private E entity;
    private List<OnCondition> onConditions = new ArrayList<OnCondition>();
    private List<WhereCondition> whereConditions = new ArrayList<WhereCondition>();
    private Set<As> fields = new HashSet<As>();
    private Set<Class<?>> entityClass = new HashSet();

    public LeftJoin(Class<E> eClass) {
        this.entity = EntityUtil.instance(eClass);
        List<String> fieldList = EntityUtil.getAllFieldName(this.entity, null, new String[0]);
        for (String field : fieldList) {
            this.fields.add(As.of(eClass, field, field));
        }
        this.entityClass.add(eClass);
    }

    public LeftJoin(E entity) {
        this.entity = entity;
        List<String> fieldList = EntityUtil.getAllFieldName(entity, null, new String[0]);
        for (String field : fieldList) {
            this.fields.add(As.of(entity.getClass(), field, field));
        }
        this.entityClass.add(entity.getClass());
    }

    public LeftJoin<E> on(On onLeft, On onRight, OnCondition ... onCondition) {
        this.onConditions.add((OnCondition)OnCondition.builder((Class)onLeft.getFirst(), (Class)onRight.getFirst()).build().eq(Left.of((Class)onLeft.getFirst(), (String)onLeft.getSecond()), Right.of((Class)onRight.getFirst(), (String)onRight.getSecond())));
        this.onConditions.addAll(Arrays.asList(onCondition));
        this.entityClass.add((Class<?>)onLeft.getFirst());
        this.entityClass.add((Class<?>)onRight.getFirst());
        for (OnCondition c : this.onConditions) {
            if (c.getEntity() != null) {
                this.entityClass.add(c.getEntity().getClass());
            }
            if (c.getEntity2() == null) continue;
            this.entityClass.add(c.getEntity2().getClass());
        }
        return this;
    }

    public LeftJoin<E> where(WhereCondition ... whereConditions) {
        this.whereConditions.addAll(Arrays.asList(whereConditions));
        return this;
    }

    public LeftJoin<E> field(As ... fieldAs) {
        this.fields.addAll(Arrays.asList(fieldAs));
        return this;
    }

    public LeftJoin<E> field(Class<?> eClass, String ... field) {
        List<String> fields = Arrays.asList(field);
        for (String f : fields) {
            this.fields.add(As.of(eClass, f, f));
        }
        return this;
    }

    public E getEntity() {
        return this.entity;
    }

    public List<OnCondition> getOnConditions() {
        return this.onConditions;
    }

    public List<WhereCondition> getWhereConditions() {
        return this.whereConditions;
    }

    public Set<As> getFields() {
        return this.fields;
    }

    public Set<Class<?>> getEntityClass() {
        return this.entityClass;
    }

    public String toString() {
        return "LeftJoin(entity=" + this.getEntity() + ", onConditions=" + this.getOnConditions() + ", whereConditions=" + this.getWhereConditions() + ", fields=" + this.getFields() + ", entityClass=" + this.getEntityClass() + ")";
    }
}

