/*
 * Decompiled with CFR 0.152.
 */
package com.github.mybatis.crud.util;

import com.github.mybatis.crud.annotation.Id;
import com.github.mybatis.crud.annotation.Table;
import com.github.mybatis.crud.structure.Three;
import com.github.mybatis.crud.util.ReflectionUtil;
import com.github.mybatis.crud.util.StringUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityUtil {
    private static final Logger log = LoggerFactory.getLogger(EntityUtil.class);

    public static <E> String getTableName(E entity) {
        String name = (String)ReflectionUtil.getAnnotationValueForType(Table.class, entity).get("name");
        String value = (String)ReflectionUtil.getAnnotationValueForType(Table.class, entity).get("value");
        return StringUtil.isNotBlank(name) ? name : value;
    }

    public static <E> Map<String, Object> getIdAnnotationValue(E entity) {
        Map<String, Object> idAnnotationValue = ReflectionUtil.getAnnotationValueForField(Id.class, entity);
        return idAnnotationValue;
    }

    public static <E> List<String> getAllFieldName(E entity, List<String> includeField, String ... excludeField) {
        return ReflectionUtil.getAllFields(entity, false, includeField, excludeField);
    }

    public static <E> List<String> getAllHaveValueFieldName(E entity, List<String> includeField, String ... excludeField) {
        return ReflectionUtil.getAllFields(entity, true, includeField, excludeField);
    }

    public static Three<String, Object, Class> getIdNameAndValueAndType(Object target) {
        return ReflectionUtil.getFieldNameAndValueByAnnotation(Id.class, target);
    }

    public static <E> boolean isOracle(E entity) {
        Map<String, Object> idAnnotationValue = EntityUtil.getIdAnnotationValue(entity);
        if (idAnnotationValue.size() == 0 || StringUtil.isBlank((String)idAnnotationValue.get("sequence"))) {
            return false;
        }
        String sequence = (String)idAnnotationValue.get("sequence");
        return StringUtil.isNotBlank(sequence);
    }

    public static <E> E copy(E source) {
        if (source == null) {
            return null;
        }
        E target = null;
        try {
            target = (E)source.getClass().newInstance();
            BeanInfo beanInfo = Introspector.getBeanInfo(source.getClass());
            for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
                Object defaultValue;
                if (descriptor.getWriteMethod() == null || (defaultValue = descriptor.getReadMethod().invoke(source, new Object[0])) == null) continue;
                descriptor.getWriteMethod().invoke(target, defaultValue);
            }
        }
        catch (IntrospectionException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.warn("copy bean error", (Throwable)e);
        }
        return target;
    }

    public static <E> E instance(Class<E> eClass) {
        if (eClass == null) {
            return null;
        }
        E entity = null;
        try {
            entity = eClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.warn("instance error:".concat(String.valueOf(eClass)), (Throwable)e);
        }
        return entity;
    }

    private EntityUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

