/*
 * Decompiled with CFR 0.152.
 */
package com.github.mybatis.crud.util;

import com.github.mybatis.crud.structure.Three;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.executor.keygen.SelectKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeyGeneratorBuilder {
    private static final Logger log = LoggerFactory.getLogger(KeyGeneratorBuilder.class);

    public static Jdbc3KeyGenerator jdbc3KeyGenerator() {
        return Jdbc3KeyGenerator.INSTANCE;
    }

    public static SelectKeyGenerator selectKeyGenerator(MappedStatement ms, Three<String, Object, Class> idNameAndValue, String sequence) {
        SelectKeyGenerator selectKeyGenerator = (SelectKeyGenerator)ms.getKeyGenerator();
        MetaObject skObject = MetaObject.forObject((Object)selectKeyGenerator, (ObjectFactory)new DefaultObjectFactory(), (ObjectWrapperFactory)new DefaultObjectWrapperFactory(), (ReflectorFactory)new DefaultReflectorFactory());
        skObject.setValue("keyStatement.keyProperties", (Object)new String[]{idNameAndValue.getFirst()});
        skObject.setValue("keyStatement.resultMaps[0].type", (Object)idNameAndValue.getThree());
        String format = "select %s.nextval FROM DUAL";
        skObject.setValue("keyStatement.sqlSource.sqlSource.sql", (Object)String.format(format, sequence));
        return selectKeyGenerator;
    }

    public static NoKeyGenerator noKeyGenerator() {
        return NoKeyGenerator.INSTANCE;
    }

    private KeyGeneratorBuilder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

