/*
 * Decompiled with CFR 0.152.
 */
package com.github.mybatis.crud.util;

import com.github.mybatis.crud.structure.Pair;
import com.github.mybatis.crud.structure.Three;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public final class ReflectionUtil
extends ReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtil.class);

    public static Map<String, Object> getAnnotationValueForType(Class<? extends Annotation> annotationClazz, Object target) {
        String[] keyValues;
        HashMap<String, Object> valueMap = new HashMap<String, Object>(2);
        Class<?> clazz = target.getClass();
        Annotation anno = clazz.getAnnotation(annotationClazz);
        String value = anno.toString();
        value = value.substring(value.indexOf("(") + 1, value.length() - 1);
        for (String keyValue : keyValues = value.split(",")) {
            String[] keyFistValueSecond = keyValue.split("=");
            valueMap.put(keyFistValueSecond[0].trim(), keyFistValueSecond.length == 2 ? keyFistValueSecond[1] : null);
        }
        return valueMap;
    }

    public static Map<String, Object> getAnnotationValueForField(Class<? extends Annotation> annotationClazz, Object target) {
        Field[] field;
        HashMap<String, Object> valueMap = new HashMap<String, Object>(1);
        Class<?> clazz = target.getClass();
        for (Field f : field = clazz.getDeclaredFields()) {
            f.setAccessible(true);
            for (Annotation annotation : f.getAnnotations()) {
                String[] keyValues;
                if (!annotation.annotationType().equals(annotationClazz)) continue;
                String value = annotation.toString();
                value = value.substring(value.indexOf("(") + 1, value.length() - 1);
                for (String keyValue : keyValues = value.split(",")) {
                    String[] keyFistValueSecond = keyValue.split("=");
                    valueMap.put(keyFistValueSecond[0].trim(), keyFistValueSecond.length == 2 ? keyFistValueSecond[1].trim() : null);
                }
            }
        }
        return valueMap;
    }

    public static List<String> getAllFields(Object target, boolean isHaveValue, List<String> includeField, String ... excludeField) {
        List<String> excludeFields = Arrays.asList(excludeField);
        boolean excludeFieldExist = excludeFields.size() > 0;
        ArrayList<String> fieldNames = new ArrayList<String>();
        Class<?> clazz = target.getClass();
        Field[] field = clazz.getDeclaredFields();
        boolean isGet = false;
        for (Field f : field) {
            if (excludeFieldExist && excludeFields.contains(f.getName())) continue;
            try {
                f.setAccessible(true);
                boolean bl = isGet = includeField != null && includeField.contains(f.getName()) || !isHaveValue || f.get(target) != null;
                if (!isGet) continue;
                fieldNames.add(f.getName());
            }
            catch (IllegalAccessException e) {
                log.warn("get field value error, field: ".concat(f.getName()), (Throwable)e);
            }
        }
        return fieldNames;
    }

    public static List<Pair<String, Class>> getAllFieldTypes(Object target, boolean isHaveValue, List<String> includeField, String ... excludeField) {
        if (target == null) {
            return null;
        }
        List<String> excludeFields = Arrays.asList(excludeField);
        boolean excludeFieldExist = excludeFields.size() > 0;
        ArrayList<Pair<String, Class>> fieldTypes = new ArrayList<Pair<String, Class>>();
        Class<?> clazz = target.getClass();
        Field[] field = clazz.getDeclaredFields();
        boolean isGet = false;
        for (Field f : field) {
            if (excludeFieldExist && excludeFields.contains(f.getName())) continue;
            try {
                f.setAccessible(true);
                boolean bl = isGet = includeField != null && includeField.contains(f.getName()) || !isHaveValue || f.get(target) != null;
                if (!isGet) continue;
                fieldTypes.add(new Pair(f.getName(), f.getType()));
            }
            catch (IllegalAccessException e) {
                log.warn("get field value error, field: ".concat(f.getName()), (Throwable)e);
            }
        }
        return fieldTypes;
    }

    public static Three<String, Object, Class> getFieldNameAndValueByAnnotation(Class<? extends Annotation> annotationClazz, Object target) {
        Field[] field;
        Class<?> c = target.getClass();
        for (Field f : field = c.getDeclaredFields()) {
            f.setAccessible(true);
            for (Annotation annotation : f.getAnnotations()) {
                if (!annotation.annotationType().equals(annotationClazz)) continue;
                try {
                    return new Three<String, Object, Class>(f.getName(), f.get(target), f.getType());
                }
                catch (IllegalAccessException e) {
                    log.warn("getFieldNameAndValueByAnnotation error", (Throwable)e);
                    return new Three<Object, Object, Object>(null, null, null);
                }
            }
        }
        return new Three<Object, Object, Object>(null, null, null);
    }

    private ReflectionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

