/*
 * Decompiled with CFR 0.152.
 */
package com.github.mybatis.crud.util;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringUtil {
    private static final Logger log = LoggerFactory.getLogger(StringUtil.class);
    public static final String LOWER_CAMEL = "LOWER_CAMEL";
    public static final String UPPER_CAMEL = "UPPER_CAMEL";
    public static final String LOWER_UNDERSCORE = "LOWER_UNDERSCORE";
    public static final String UPPER_UNDERSCORE = "UPPER_UNDERSCORE";
    private static final Pattern HUMP_PATTERN = Pattern.compile("[A-Z]");
    public static final String EMPTY = "";
    private static final Pattern NUMBER = Pattern.compile("[1-9]\\d*");

    public static boolean isNotBlank(String str) {
        return str != null && str.trim().length() > 0;
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String camelToUnderscore(String camel, String camelType, String underscoreType) {
        if (StringUtil.isBlank(camel)) {
            return camel;
        }
        Matcher matcher = NUMBER.matcher(camel);
        if (matcher.matches()) {
            return camel;
        }
        matcher = HUMP_PATTERN.matcher(camel);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        String underscore = sb.toString();
        if (UPPER_CAMEL.equals(camelType)) {
            underscore = underscore.substring(1);
        }
        if (UPPER_UNDERSCORE.equals(underscoreType)) {
            underscore = underscore.toUpperCase();
        }
        return underscore;
    }

    public static String defaultEmptyIfBlank(String str) {
        if (StringUtil.isBlank(str)) {
            return EMPTY;
        }
        return str;
    }

    public static String join(List list, String separator) {
        StringBuffer joins = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            joins.append(list.get(i).toString());
            if (i >= list.size() - 1) continue;
            joins.append(separator);
        }
        return joins.toString();
    }

    private StringUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

