/*
 * Decompiled with CFR 0.152.
 */
package com.github.mybatis.crud.handler;

import com.github.mybatis.crud.annotation.Id;
import com.github.mybatis.crud.handler.DefaultIdFillHandler;
import com.github.mybatis.crud.handler.InsertMybatisInterceptorHandler;
import com.github.mybatis.crud.structure.Three;
import com.github.mybatis.crud.util.EntityUtil;
import com.github.mybatis.crud.util.KeyGeneratorBuilder;
import com.github.mybatis.crud.util.ReflectionUtil;
import com.github.mybatis.crud.util.StringUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdSetHandler
implements InsertMybatisInterceptorHandler {
    private static final Logger log = LoggerFactory.getLogger(IdSetHandler.class);
    private MappedStatement ms;
    private Object parameter;

    @Override
    public void before(Invocation invocation) {
        Object[] args = invocation.getArgs();
        this.parameter = args[1];
        this.ms = (MappedStatement)args[0];
        this.handleInsert();
    }

    private void handleInsert() {
        Object target = this.parameter;
        List list = null;
        if (this.parameter instanceof Map) {
            list = (List)((Map)this.parameter).get("list");
            target = list.get(0);
        }
        MetaObject msObject = MetaObject.forObject((Object)this.ms, (ObjectFactory)new DefaultObjectFactory(), (ObjectWrapperFactory)new DefaultObjectWrapperFactory(), (ReflectorFactory)new DefaultReflectorFactory());
        Three<String, Object, Class> idNameAndValue = EntityUtil.getIdNameAndValueAndType(target);
        Id id = EntityUtil.getIdAnnotation(target);
        String sequence = id.sequence();
        if (StringUtil.isNotBlank(sequence)) {
            if (list == null) {
                msObject.setValue("keyGenerator", (Object)KeyGeneratorBuilder.selectKeyGenerator(this.ms, idNameAndValue, sequence));
            } else {
                msObject.setValue("keyGenerator", (Object)KeyGeneratorBuilder.noKeyGenerator());
            }
            return;
        }
        if (id.isManualFill()) {
            msObject.setValue("keyGenerator", (Object)KeyGeneratorBuilder.noKeyGenerator());
            return;
        }
        switch (id.fillMethod()) {
            case UUID: {
                Field idField = ReflectionUtil.findField(target.getClass(), (String)idNameAndValue.getFirst());
                if (idField == null) break;
                ReflectionUtil.makeAccessible((Field)idField);
                ReflectionUtil.setField((Field)idField, (Object)target, (Object)UUID.randomUUID().toString());
                break;
            }
            case CUSTOM_HANDLE: {
                if (DefaultIdFillHandler.class.equals(id.fillHandler())) break;
                DefaultIdFillHandler idFillHandler = EntityUtil.instance(id.fillHandler());
                Field idField = ReflectionUtil.findField(target.getClass(), (String)idNameAndValue.getFirst());
                if (idField == null) break;
                ReflectionUtil.makeAccessible((Field)idField);
                ReflectionUtil.setField((Field)idField, (Object)target, idFillHandler.fill());
                break;
            }
        }
        msObject.setValue("keyGenerator", (Object)KeyGeneratorBuilder.jdbc3KeyGenerator());
        msObject.setValue("keyProperties", (Object)new String[]{idNameAndValue.getFirst()});
    }
}

