/*
 * Decompiled with CFR 0.152.
 */
package com.github.mybatis.crud.handler;

import com.github.mybatis.crud.handler.DeleteMybatisInterceptorHandler;
import com.github.mybatis.crud.handler.SelectMybatisInterceptorHandler;
import com.github.mybatis.crud.handler.UpdateMybatisInterceptorHandler;
import com.github.mybatis.crud.structure.AbstractCondition;
import com.github.mybatis.crud.structure.Condition;
import com.github.mybatis.crud.structure.LeftJoin;
import com.github.mybatis.crud.structure.OnCondition;
import com.github.mybatis.crud.structure.Update;
import com.github.mybatis.crud.structure.Where;
import com.github.mybatis.crud.structure.WhereCondition;
import com.github.mybatis.crud.util.ReflectionUtil;
import com.github.mybatis.crud.util.StringUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.plugin.Invocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LikeEscapeHandler
implements DeleteMybatisInterceptorHandler,
UpdateMybatisInterceptorHandler,
SelectMybatisInterceptorHandler {
    private static final Logger log = LoggerFactory.getLogger(LikeEscapeHandler.class);

    @Override
    public void before(Invocation invocation) {
        Object leftJoin;
        Object[] args = invocation.getArgs();
        Object parameter = args[1];
        if (parameter instanceof Condition) {
            args[1] = this.handleAbstractCondition((AbstractCondition)parameter);
        } else if (parameter instanceof Update) {
            ((Update)parameter).setCondition((Condition)this.handleAbstractCondition(((Update)parameter).getCondition()));
        } else if (parameter instanceof MapperMethod.ParamMap && ((MapperMethod.ParamMap)parameter).containsKey((Object)"leftJoin") && (leftJoin = ((MapperMethod.ParamMap)parameter).get((Object)"leftJoin")) != null && leftJoin instanceof LeftJoin) {
            ArrayList<OnCondition> onConditions = new ArrayList<OnCondition>();
            ArrayList<WhereCondition> whereConditions = new ArrayList<WhereCondition>();
            for (OnCondition onCondition : ((LeftJoin)leftJoin).getOnConditions()) {
                onConditions.add((OnCondition)this.handleAbstractCondition(onCondition));
            }
            for (WhereCondition whereCondition : ((LeftJoin)leftJoin).getWhereConditions()) {
                whereConditions.add((WhereCondition)this.handleAbstractCondition(whereCondition));
            }
            Field onConditionsField = ReflectionUtil.findField(leftJoin.getClass(), (String)"onConditions");
            Field field = ReflectionUtil.findField(leftJoin.getClass(), (String)"whereConditions");
            ReflectionUtil.makeAccessible((Field)onConditionsField);
            ReflectionUtil.makeAccessible((Field)field);
            ReflectionUtil.setField((Field)onConditionsField, (Object)leftJoin, onConditions);
            ReflectionUtil.setField((Field)field, (Object)leftJoin, whereConditions);
        }
    }

    private <E> AbstractCondition handleAbstractCondition(AbstractCondition ac) {
        AbstractCondition condition;
        E entity = null;
        Object entity2 = null;
        List<Where> wheres = null;
        Condition abstractCondition = null;
        if (ac instanceof Condition) {
            condition = new Condition((Condition)ac);
            abstractCondition = condition;
            entity = condition.getEntity();
            wheres = condition.getWheres();
        } else if (ac instanceof OnCondition) {
            condition = new OnCondition((OnCondition)ac);
            abstractCondition = condition;
            entity = condition.getEntity();
            entity2 = ((OnCondition)condition).getEntity2();
            wheres = condition.getWheres();
        } else if (ac instanceof WhereCondition) {
            condition = new WhereCondition((WhereCondition)ac);
            abstractCondition = condition;
            entity = condition.getEntity();
            entity2 = ((WhereCondition)condition).getEntity2();
            wheres = condition.getWheres();
        }
        for (Where where : wheres) {
            if (!"like".equalsIgnoreCase(where.getSymbol()) || !where.getIsPre().booleanValue()) continue;
            log.trace("like \u8f6c\u4e49 ->");
            this.handlePre(entity, where);
            this.handlePre(entity2, where);
        }
        return abstractCondition;
    }

    private <E> void handlePre(E entity, Where where) {
        if (entity == null) {
            return;
        }
        String likeColumn = where.getColumn();
        Field likeField = ReflectionUtil.findField(entity.getClass(), (String)likeColumn);
        if (String.class.equals(likeField.getType())) {
            ReflectionUtil.makeAccessible((Field)likeField);
            String value = (String)ReflectionUtil.getField((Field)likeField, entity);
            if (StringUtil.isBlank(value)) {
                return;
            }
            value = value.replaceAll("/", "//");
            value = value.replaceAll("_", "/_");
            value = value.replaceAll("%", "/%");
            ReflectionUtil.setField((Field)likeField, entity, (Object)value);
            log.trace("\u66f4\u65b0\u5217{},\u503c\u4e3a{}", (Object)likeColumn, (Object)value);
        }
    }
}

