/*
 * Decompiled with CFR 0.152.
 */
package com.github.mybatis.crud.handler;

import com.github.mybatis.crud.handler.SelectMybatisInterceptorHandler;
import com.github.mybatis.crud.structure.Condition;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultTypeHandler
implements SelectMybatisInterceptorHandler {
    private static final Logger log = LoggerFactory.getLogger(ResultTypeHandler.class);
    private final String SQL_ID_LIST = "com.github.mybatis.crud.mapper.DefaultMapper.list";
    private final String SQL_ID_DETAIL = "com.github.mybatis.crud.mapper.DefaultMapper.detail";

    @Override
    public void before(Invocation invocation) {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Object parameter = args[1];
        if (parameter instanceof MapperMethod.ParamMap && ((MapperMethod.ParamMap)parameter).get((Object)"resultTypeClass") instanceof Class) {
            Class resultType = (Class)((MapperMethod.ParamMap)parameter).get((Object)"resultTypeClass");
            this.setResultType(ms, resultType);
        } else if (Arrays.asList("com.github.mybatis.crud.mapper.DefaultMapper.detail", "com.github.mybatis.crud.mapper.DefaultMapper.list").contains(ms.getId())) {
            this.setResultType(ms, ((Condition)parameter).getEntity().getClass());
        }
    }

    private void setResultType(MappedStatement ms, Class<?> resultType) {
        ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
        ResultMap resultMap = new ResultMap.Builder(ms.getConfiguration(), ms.getId(), resultType, new ArrayList(0)).build();
        resultMaps.add(resultMap);
        MetaObject msObject = MetaObject.forObject((Object)ms, (ObjectFactory)new DefaultObjectFactory(), (ObjectWrapperFactory)new DefaultObjectWrapperFactory(), (ReflectorFactory)new DefaultReflectorFactory());
        msObject.setValue("resultMaps", resultMaps);
    }
}

