/*
 * Decompiled with CFR 0.152.
 */
package com.github.mybatis.crud.provider;

import com.github.mybatis.crud.helper.SqlHelper;
import com.github.mybatis.crud.structure.Condition;
import com.github.mybatis.crud.structure.Three;
import com.github.mybatis.crud.util.EntityUtil;
import java.util.List;
import org.apache.ibatis.jdbc.SQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class DefaultDeleteProvider<E> {
    private static final Logger log = LoggerFactory.getLogger(DefaultDeleteProvider.class);
    private String tableName;
    private Three<String, Object, Class> idNameAndValue;

    public String deleteByPrimaryKey(E entity) {
        this.initValue(entity);
        return new SQL(){
            {
                this.DELETE_FROM(DefaultDeleteProvider.this.tableName);
                this.WHERE(SqlHelper.camelToUnderscore((String)DefaultDeleteProvider.this.idNameAndValue.getFirst()).concat("=").concat("#{").concat((String)DefaultDeleteProvider.this.idNameAndValue.getFirst()).concat("}"));
            }
        }.toString();
    }

    public String delete(Condition<E> condition) {
        Assert.isTrue((condition.getWheres() != null && condition.getWheres().size() > 0 ? 1 : 0) != 0, (String)"where can not be null");
        this.initValue(condition.getEntity());
        StringBuffer sql = new StringBuffer(((SQL)new SQL().DELETE_FROM(this.tableName)).toString());
        sql.append(SqlHelper.buildWhere(condition));
        return sql.toString();
    }

    public String batchDelete(List<E> list) {
        Assert.isTrue((list != null && list.size() > 0 ? 1 : 0) != 0, (String)"list can not be null");
        this.initValue(list.get(0));
        StringBuffer sql = new StringBuffer(((SQL)new SQL().DELETE_FROM(this.tableName)).toString());
        Condition condition = (Condition)Condition.builder(list.get(0)).build().in(this.idNameAndValue.getFirst(), EntityUtil.getIdList(list));
        sql.append(SqlHelper.buildWhere(condition));
        return sql.toString();
    }

    private void initValue(E entity) {
        this.tableName = EntityUtil.getTableName(entity);
        this.idNameAndValue = EntityUtil.getIdNameAndValueAndType(entity);
    }
}

