/*
 * Decompiled with CFR 0.152.
 */
package com.github.mybatis.crud.structure;

import com.github.mybatis.crud.structure.Pair;
import com.github.mybatis.crud.structure.Where;
import com.github.mybatis.crud.util.EntityUtil;
import com.github.mybatis.crud.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractCondition<E, C extends AbstractCondition> {
    private E entity;
    private List<Pair<String, Class>> fieldTypes;
    private List<Where> wheres = new ArrayList<Where>();
    private Map<String, Object> param = new HashMap<String, Object>();

    public AbstractCondition(Class<E> eClass) {
        this.entity = EntityUtil.instance(eClass);
        this.fieldTypes = ReflectionUtil.getAllFieldTypes(this.entity, false, null, new String[0]);
    }

    public AbstractCondition(E entity) {
        this.entity = EntityUtil.copy(entity);
        this.fieldTypes = ReflectionUtil.getAllFieldTypes(this.entity, false, null, new String[0]);
    }

    public AbstractCondition(C source) {
        this.entity = EntityUtil.copy(((AbstractCondition)source).getEntity());
        this.fieldTypes = ((AbstractCondition)source).getFieldTypes();
        this.wheres = ((AbstractCondition)source).getWheres();
    }

    public void setParam(Map<String, Object> param) {
        if (param.size() == 0) {
            this.param = param;
        } else {
            this.param.putAll(param);
        }
    }

    public Map<String, Object> getParam() {
        return this.param;
    }

    public List<Where> getWheres() {
        return this.wheres;
    }

    protected void setWheres(List<Where> wheres) {
        this.wheres = wheres;
    }

    public E getEntity() {
        return this.entity;
    }

    public List<Pair<String, Class>> getFieldTypes() {
        return this.fieldTypes;
    }

    public C entity(E entity) {
        this.entity = EntityUtil.copy(entity);
        this.fieldTypes = ReflectionUtil.getAllFieldTypes(this.entity, false, null, new String[0]);
        return (C)this;
    }
}

