/*
 * Decompiled with CFR 0.152.
 */
package com.wujiuye.jsonparser.adapter;

import com.wujiuye.jsonparser.core.JsonUtils;
import com.wujiuye.jsonparser.core.SerializeConfig;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JsonParserSerializeConfiguration
implements InitializingBean {
    @Value(value="${spring.json-parser.serialize-null:false}")
    private boolean serializeNulls;
    @Value(value="${spring.json-parser.date-format:yyyy-MM-dd HH:mm:ss}")
    private String dateFormat;
    @Value(value="${spring.json-parser.local-date-format:yyyy-MM-dd}")
    private String localDateFormat;
    @Value(value="${spring.json-parser.local-date-time-format:yyyy-MM-dd HH:mm:ss}")
    private String localDateTimeFormat;
    @Value(value="${spring.json-parser.timezone:8}")
    private Integer timezone;
    @Value(value="${spring.json-parser.open-xss-filter:true}")
    private Boolean openXssFilter;

    public void afterPropertiesSet() {
        SerializeConfig serializeConfig = new SerializeConfig();
        serializeConfig.setSerializeNulls(this.serializeNulls);
        serializeConfig.setTimezone(this.timezone.intValue());
        serializeConfig.setDateFormat(this.dateFormat);
        serializeConfig.setLocalDateFormat(this.localDateFormat);
        serializeConfig.setLocalDateTimeFormat(this.localDateTimeFormat);
        serializeConfig.setOpenXssFilter(this.openXssFilter.booleanValue());
        JsonUtils.resetSerializeConfig((SerializeConfig)serializeConfig);
    }
}

