/*
 * Decompiled with CFR 0.152.
 */
package com.wujiuye.jsonparser.adapter.webflux;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.wujiuye.jsonparser.adapter.webflux.WebFluxCondition;
import com.wujiuye.jsonparser.core.JsonUtils;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Map;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.DecodingException;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.config.WebFluxConfigurer;

@Conditional(value={WebFluxCondition.class})
@Configuration
public class WebFluxJsonConverterConfiguration
implements WebFluxConfigurer {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public void configureHttpMessageCodecs(ServerCodecConfigurer configurer) {
        configurer.defaultCodecs().jackson2JsonEncoder((Encoder)new Jackson2JsonEncoder(this.objectMapper, new MimeType[0]){

            public DataBuffer encodeValue(Object value, DataBufferFactory bufferFactory, ResolvableType valueType, MimeType mimeType, Map<String, Object> hints) {
                byte[] bytes = JsonUtils.toJsonString((Object)value).getBytes();
                DataBuffer buffer = bufferFactory.allocateBuffer(bytes.length);
                return buffer.write(bytes);
            }
        });
        configurer.defaultCodecs().jackson2JsonDecoder((Decoder)new Jackson2JsonDecoder(this.objectMapper, new MimeType[0]){

            public Object decode(DataBuffer dataBuffer, ResolvableType targetType, MimeType mimeType, Map<String, Object> hints) throws DecodingException {
                try {
                    Object object = JsonUtils.fromJson((InputStream)dataBuffer.asInputStream(), (Type)targetType.getType());
                    return object;
                }
                catch (Throwable ex) {
                    throw new RuntimeException("\u89e3\u7801\u5f02\u5e38\uff0ctargetType=" + targetType.getType());
                }
                finally {
                    DataBufferUtils.release((DataBuffer)dataBuffer);
                }
            }
        });
    }
}

