/*
 * Decompiled with CFR 0.152.
 */
package com.wujiuye.jsonparser.adapter.webmvc;

import com.fasterxml.jackson.core.JsonEncoding;
import com.wujiuye.jsonparser.core.JsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractGenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.lang.Nullable;

public class JsonHttpMessageConverter
extends AbstractGenericHttpMessageConverter<Object> {
    private static final List<MediaType> SUPPOR_MEDIA_TYPE = Arrays.asList(MediaType.APPLICATION_JSON, MediaType.valueOf((String)"application/vnd.spring-boot.actuator.v3+json"));

    protected boolean supports(Class<?> clazz) {
        return String.class != clazz;
    }

    public boolean canRead(Type type, Class<?> contextClass, MediaType mediaType) {
        return this.canRead(mediaType);
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return this.canRead(mediaType);
    }

    protected boolean canRead(MediaType mediaType) {
        return super.canRead(mediaType);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return SUPPOR_MEDIA_TYPE;
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return this.canWrite(mediaType);
    }

    public boolean canWrite(Type type, Class<?> clazz, MediaType mediaType) {
        return this.canWrite(mediaType);
    }

    protected boolean canWrite(MediaType mediaType) {
        return super.canRead(mediaType);
    }

    protected void writeInternal(Object object, Type type, HttpOutputMessage httpOutputMessage) throws IOException, HttpMessageNotWritableException {
        MediaType contentType = httpOutputMessage.getHeaders().getContentType();
        JsonEncoding encoding = this.getJsonEncoding(contentType);
        String json = object instanceof String ? (String)object : JsonUtils.toJsonString((Object)object);
        OutputStream outputStream = httpOutputMessage.getBody();
        outputStream.write(json.getBytes(encoding.getJavaName()));
        outputStream.flush();
    }

    protected Object readInternal(Class<?> aClass, HttpInputMessage httpInputMessage) throws IOException, HttpMessageNotReadableException {
        InputStream inputStream = httpInputMessage.getBody();
        return JsonUtils.fromJson((InputStream)inputStream, aClass);
    }

    public Object read(Type type, Class<?> aClass, HttpInputMessage httpInputMessage) throws IOException, HttpMessageNotReadableException {
        InputStream inputStream = httpInputMessage.getBody();
        return JsonUtils.fromJson((InputStream)inputStream, (Type)type);
    }

    private String readMessageBody(InputStream inputStream) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        return sb.toString();
    }

    protected JsonEncoding getJsonEncoding(@Nullable MediaType contentType) {
        if (contentType != null && contentType.getCharset() != null) {
            JsonEncoding[] encodings;
            Charset charset = contentType.getCharset();
            for (JsonEncoding encoding : encodings = JsonEncoding.values()) {
                if (!charset.name().equals(encoding.getJavaName())) continue;
                return encoding;
            }
        }
        return JsonEncoding.UTF8;
    }
}

