/*
 * Decompiled with CFR 0.152.
 */
package com.wujiuye.jsonparser.adapter.webmvc;

import com.wujiuye.jsonparser.adapter.webmvc.JsonHttpMessageConverter;
import com.wujiuye.jsonparser.adapter.webmvc.WebMvcCondition;
import java.util.Iterator;
import java.util.List;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Conditional(value={WebMvcCondition.class})
@Configuration(proxyBeanMethods=false)
public class WebMvcJsonConverterConfiguration
implements WebMvcConfigurer {
    public void configureMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        Iterator<HttpMessageConverter<?>> iterable = messageConverters.iterator();
        AllEncompassingFormHttpMessageConverter formHttpMessageConverter = null;
        while (iterable.hasNext()) {
            HttpMessageConverter<?> converter = iterable.next();
            if (converter instanceof MappingJackson2HttpMessageConverter) {
                iterable.remove();
            }
            if (!(converter instanceof AllEncompassingFormHttpMessageConverter)) continue;
            iterable.remove();
            formHttpMessageConverter = new AllEncompassingFormHttpMessageConverter(){

                public void addPartConverter(HttpMessageConverter<?> partConverter) {
                    if (partConverter instanceof MappingJackson2HttpMessageConverter) {
                        partConverter = WebMvcJsonConverterConfiguration.this.messageConverter();
                    }
                    super.addPartConverter(partConverter);
                }
            };
        }
        if (formHttpMessageConverter != null) {
            messageConverters.add((HttpMessageConverter<?>)formHttpMessageConverter);
        }
        messageConverters.add((HttpMessageConverter<?>)this.messageConverter());
    }

    private JsonHttpMessageConverter messageConverter() {
        return new JsonHttpMessageConverter();
    }
}

