/*
 * Decompiled with CFR 0.152.
 */
package com.github.wzc789376152.file;

import com.github.wzc789376152.file.FtpProperties;
import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpClientFactory
implements PooledObjectFactory<FTPClient> {
    protected FtpProperties properties;

    public FtpClientFactory(FtpProperties properties) {
        this.properties = properties;
        if (properties == null) {
            properties = new FtpProperties();
        }
    }

    public PooledObject<FTPClient> makeObject() {
        FTPClient ftpClient = new FTPClient();
        return new DefaultPooledObject((Object)ftpClient);
    }

    public void destroyObject(PooledObject<FTPClient> pooledObject) {
        FTPClient ftpClient = (FTPClient)pooledObject.getObject();
        try {
            ftpClient.logout();
            if (ftpClient.isConnected()) {
                ftpClient.disconnect();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not disconnect from server.", e);
        }
    }

    public boolean validateObject(PooledObject<FTPClient> pooledObject) {
        FTPClient ftpClient = (FTPClient)pooledObject.getObject();
        try {
            return ftpClient.sendNoOp();
        }
        catch (IOException e) {
            return false;
        }
    }

    public void activateObject(PooledObject<FTPClient> pooledObject) throws Exception {
        FTPClient ftpClient = (FTPClient)pooledObject.getObject();
        ftpClient.connect(this.properties.getHost(), this.properties.getPort());
        ftpClient.login(this.properties.getUsername(), this.properties.getPassword());
        if (this.properties.getEncoding() != null) {
            ftpClient.setControlEncoding(this.properties.getEncoding());
        }
        ftpClient.setFileType(2);
    }

    public void passivateObject(PooledObject<FTPClient> pooledObject) throws Exception {
        FTPClient ftpClient = (FTPClient)pooledObject.getObject();
        try {
            ftpClient.changeWorkingDirectory("/");
            ftpClient.logout();
            if (ftpClient.isConnected()) {
                ftpClient.disconnect();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not disconnect from server.", e);
        }
    }

    public FtpProperties getProperties() {
        return this.properties;
    }
}

