/*
 * Decompiled with CFR 0.152.
 */
package com.github.wzc789376152.file;

import com.github.wzc789376152.file.FtpClientFactory;
import com.github.wzc789376152.file.FtpProperties;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class FtpPool {
    private FtpClientFactory factory;
    private GenericObjectPool<FTPClient> internalPool;

    public FtpClientFactory getFactory() {
        return this.factory;
    }

    public FtpPool(FtpClientFactory factory) {
        this.factory = factory;
        this.initPool();
    }

    private void initPool() {
        FtpProperties properties = this.factory.getProperties();
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxTotal(properties.getMaxTotal());
        poolConfig.setMinIdle(properties.getMinIdel());
        poolConfig.setMaxIdle(properties.getMaxIdle());
        poolConfig.setMaxWaitMillis((long)properties.getMaxWaitMillis());
        this.internalPool = new GenericObjectPool((PooledObjectFactory)this.factory, poolConfig);
    }

    public FTPClient getFTPClient() {
        try {
            return (FTPClient)this.internalPool.borrowObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void returnFTPClient(FTPClient ftpClient) {
        try {
            this.internalPool.returnObject((Object)ftpClient);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void destroy() {
        try {
            this.internalPool.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

