/*
 * Decompiled with CFR 0.152.
 */
package com.github.wzc789376152.file.manager;

import com.github.wzc789376152.file.FileProperties;
import com.github.wzc789376152.file.FtpClientFactory;
import com.github.wzc789376152.file.FtpPool;
import com.github.wzc789376152.file.FtpProperties;
import com.github.wzc789376152.file.manager.IFileManager;
import com.github.wzc789376152.file.utils.FilePathUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FtpFileManagerAbstract
implements IFileManager {
    Logger logger = Logger.getLogger(IFileManager.class.getName());
    protected FtpProperties ftpProperties;
    private FtpPool ftpPool;

    public abstract FtpProperties ftpProperties();

    public void init(FileProperties fileProperties) {
        this.logger.info("use ftpFileManager");
        if (this.ftpProperties == null) {
            this.ftpProperties = this.ftpProperties();
            if (this.ftpProperties == null) {
                throw new RuntimeException("\u672a\u8fdb\u884cftp\u914d\u7f6e");
            }
        }
        fileProperties.setWorkDir(FilePathUtils.formatPath((String)fileProperties.getWorkDir()));
        FtpClientFactory ftpClientFactory = new FtpClientFactory(this.ftpProperties);
        this.ftpPool = new FtpPool(ftpClientFactory);
        FTPClient ftpClient = this.ftpPool.getFTPClient();
        if (fileProperties.getWorkDir().endsWith(File.separator)) {
            fileProperties.setWorkDir(fileProperties.getWorkDir().substring(0, fileProperties.getWorkDir().length() - 1));
        }
        fileProperties.setWorkDir(fileProperties.getWorkDir().replace(File.separator, "/"));
        try {
            if (!ftpClient.changeWorkingDirectory(fileProperties.getWorkDir()) && ftpClient.makeDirectory(fileProperties.getWorkDir())) {
                ftpClient.changeWorkingDirectory(fileProperties.getWorkDir());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.ftpPool.returnFTPClient(ftpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllFilesName() {
        FTPClient client = this.ftpPool.getFTPClient();
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (FTPFile file : client.listFiles()) {
                if (!file.isFile()) continue;
                result.add(file.getName());
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            this.ftpPool.returnFTPClient(client);
        }
        return null;
    }

    public void upload(String filename, InputStream inputStream) throws IOException {
        boolean result;
        FTPClient ftpClient = this.ftpPool.getFTPClient();
        if (ftpClient.listFiles(filename).length == 0 && !(result = ftpClient.storeFile(filename, inputStream))) {
            throw new IOException("\u8fdc\u7a0b\u4e0a\u4f20\u5931\u8d25");
        }
        this.ftpPool.returnFTPClient(ftpClient);
    }

    public void download(String filename, OutputStream outputStream) throws IOException {
        FTPClient ftpClient = this.ftpPool.getFTPClient();
        boolean is = ftpClient.retrieveFile(filename, outputStream);
        if (!is) {
            throw new IOException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        this.ftpPool.returnFTPClient(ftpClient);
    }

    public void delete(String filename) throws IOException {
        FTPClient ftpClient = this.ftpPool.getFTPClient();
        boolean is = ftpClient.deleteFile(filename);
        this.ftpPool.returnFTPClient(ftpClient);
        if (!is) {
            throw new IOException("ftp\u6587\u4ef6\u5220\u9664\u5931\u8d25!");
        }
    }

    public void changeWorkDir(String filepath) throws IOException {
        FTPClient ftpClient = this.ftpPool.getFTPClient();
        if (filepath.endsWith(File.separator)) {
            filepath = filepath.substring(0, filepath.length() - 1);
        }
        filepath = filepath.replace(File.separator, "/");
        try {
            if (!ftpClient.changeWorkingDirectory(filepath) && ftpClient.makeDirectory(filepath)) {
                ftpClient.changeWorkingDirectory(filepath);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.ftpPool.returnFTPClient(ftpClient);
        }
    }

    public void setFtpProperties(FtpProperties ftpProperties) {
        this.ftpProperties = ftpProperties;
    }
}

