/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.easyjdbc.springboot.autoconfigure;

import com.xphsc.easyjdbc.EasyJdbcTemplate;
import com.xphsc.easyjdbc.core.factory.EasyDaoBeanFactory;
import com.xphsc.easyjdbc.core.factory.EasyDaoBeanScannerConfigurer;
import com.xphsc.easyjdbc.springboot.autoconfigure.EasyJdbcProperties;
import com.xphsc.easyjdbc.util.StringUtil;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Repository;

@Configuration
@EnableConfigurationProperties(value={EasyJdbcProperties.class})
@AutoConfigureAfter(value={JdbcTemplateAutoConfiguration.class})
public class EasyJdbcAutoConfiguration {
    private DataSource dataSource;
    private EasyJdbcProperties easyJdbcProperties;

    public EasyJdbcAutoConfiguration(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Bean
    public EasyJdbcTemplate easyJdbcTemplate() {
        return new EasyJdbcTemplate(this.dataSource, this.easyJdbcProperties.getDialect());
    }

    public EasyJdbcProperties getEasyJdbcProperties() {
        return this.easyJdbcProperties;
    }

    @Autowired
    public void setEasyJdbcProperties(EasyJdbcProperties easyJdbcProperties) {
        this.easyJdbcProperties = easyJdbcProperties;
    }

    @Configuration
    @Import(value={AutoConfiguredDaoScannerRegistrar.class})
    @ConditionalOnMissingBean(value={EasyDaoBeanFactory.class})
    public static class daoScannerRegistrarNotFoundConfiguration {
        @PostConstruct
        public void afterPropertiesSet() {
        }
    }

    public static class AutoConfiguredDaoScannerRegistrar
    implements EnvironmentAware {
        private String basePackages = null;

        @Bean
        public EasyDaoBeanScannerConfigurer easyDaoBeanScannerConfigurer() {
            EasyDaoBeanScannerConfigurer daoBeanScannerConfigurer = new EasyDaoBeanScannerConfigurer();
            daoBeanScannerConfigurer.setBasePackage(StringUtil.isNotBlank((CharSequence)this.basePackages) ? this.basePackages : "com.*");
            daoBeanScannerConfigurer.setAnnotation(Repository.class);
            return daoBeanScannerConfigurer;
        }

        public void setEnvironment(Environment environment) {
            String basePackage;
            this.basePackages = basePackage = environment.getProperty("easyjdbc.basePackage");
        }
    }
}

