/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core;

import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.executor.CountExecutor;
import com.xphsc.elasticsearch.core.executor.CreateEntityExecutor;
import com.xphsc.elasticsearch.core.executor.CreateExecutor;
import com.xphsc.elasticsearch.core.executor.DeleteEntityExecutor;
import com.xphsc.elasticsearch.core.executor.DeleteExecutor;
import com.xphsc.elasticsearch.core.executor.ExistExecutor;
import com.xphsc.elasticsearch.core.executor.GetEntityExecutor;
import com.xphsc.elasticsearch.core.executor.PutExecutor;
import com.xphsc.elasticsearch.core.executor.RefreshExecutor;
import com.xphsc.elasticsearch.core.executor.SelectEntityExecutor;
import com.xphsc.elasticsearch.core.executor.UpdateEntityExecutor;
import com.xphsc.elasticsearch.core.query.QueryCriteria;
import com.xphsc.elasticsearch.core.support.ElasticsearchAccessor;
import com.xphsc.elasticsearch.page.Page;
import com.xphsc.elasticsearch.util.Asserts;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class ElasticsearchTemplate
extends ElasticsearchAccessor {
    public RestHighLevelClientBulider getClient() {
        return this.initClient();
    }

    public boolean createIndex(String indexName) {
        Asserts.notNull(indexName, "No index defined for createIndex()");
        CreateExecutor executor = new CreateExecutor(this.getClient(), indexName);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    public <T> boolean createIndex(Class<T> clazz) {
        CreateExecutor executor = new CreateExecutor(this.getClient(), clazz);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    public <T> boolean deleteIndex(String indexName) {
        Asserts.notNull(indexName, "No index defined for deleteIndex()");
        DeleteExecutor executor = new DeleteExecutor(this.getClient(), indexName);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    public <T> boolean deleteIndex(Class<T> clazz) {
        DeleteExecutor executor = new DeleteExecutor(this.getClient(), clazz);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    public <T> boolean putMapping(Class<T> clazz) {
        PutExecutor executor = new PutExecutor(this.getClient(), clazz);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    public <T> T save(Object entity) {
        CreateEntityExecutor<Object> executor = new CreateEntityExecutor<Object>(this.getClient(), entity);
        Object result = executor.execute();
        executor = null;
        return result;
    }

    public <T> T get(Object entity) {
        GetEntityExecutor<Object> executor = new GetEntityExecutor<Object>(this.getClient(), entity);
        Object result = executor.execute();
        executor = null;
        return result;
    }

    public <T> T get(Serializable id, Class<T> clazz) {
        GetEntityExecutor executor = new GetEntityExecutor(this.getClient(), clazz, id);
        Object result = executor.execute();
        executor = null;
        return result;
    }

    public <T> int delete(Object entity) {
        DeleteEntityExecutor<Object> executor = new DeleteEntityExecutor<Object>(this.getClient(), entity);
        int result = (Integer)executor.execute();
        executor = null;
        return result;
    }

    public <T> int delete(Class<T> entity, Serializable id) {
        DeleteEntityExecutor executor = new DeleteEntityExecutor(this.getClient(), entity, id);
        int result = (Integer)executor.execute();
        executor = null;
        return result;
    }

    public <T> int deleteByIds(Class<T> entity, List<?> ids) {
        DeleteEntityExecutor<T> executor = new DeleteEntityExecutor<T>(this.getClient(), entity, ids);
        int result = (Integer)executor.execute();
        executor = null;
        return result;
    }

    public <T> T update(Object entity) {
        UpdateEntityExecutor<Object> executor = new UpdateEntityExecutor<Object>(this.getClient(), entity);
        Object result = executor.execute();
        executor = null;
        return result;
    }

    public <T> int update(List<T> entities) {
        UpdateEntityExecutor<T> executor = new UpdateEntityExecutor<T>(this.getClient(), entities, true);
        int result = (Integer)executor.execute();
        executor = null;
        return result;
    }

    public <T> T update(Serializable id, Object entity) {
        Asserts.notNull(id, "No _id defined for update()");
        UpdateEntityExecutor<Object> executor = new UpdateEntityExecutor<Object>(this.getClient(), entity, id);
        Object result = executor.execute();
        executor = null;
        return result;
    }

    public <T> int save(List<T> entities) {
        CreateEntityExecutor<T> executor = new CreateEntityExecutor<T>(this.getClient(), entities);
        int result = (Integer)executor.execute();
        executor = null;
        return result;
    }

    public boolean createIndex(String indexName, String alias, int shards, int replicas, String refreshInterval, String indexStoreType) {
        boolean result = false;
        if (!this.indexExist(indexName)) {
            CreateExecutor executor = new CreateExecutor(this.getClient(), indexName, alias, shards, replicas, refreshInterval, indexStoreType);
            result = (Boolean)executor.execute();
            executor = null;
        }
        return result;
    }

    public boolean createIndex(String indexName, String alias, int shards, int replicas, int maxResult, String refreshInterval, String indexStoreType) {
        boolean result = false;
        if (!this.indexExist(indexName)) {
            CreateExecutor executor = new CreateExecutor(this.getClient(), indexName, alias, shards, replicas, maxResult, refreshInterval, indexStoreType);
            result = (Boolean)executor.execute();
            executor = null;
        }
        return result;
    }

    public void refresh(String indexName) {
        Asserts.notNull(indexName, "No index defined for refresh()");
        RefreshExecutor executor = new RefreshExecutor(this.getClient(), indexName);
        executor.execute();
    }

    public <T> boolean refresh(Class<T> clazz) {
        RefreshExecutor executor = new RefreshExecutor(this.getClient(), clazz);
        boolean result = (Boolean)executor.execute();
        return result;
    }

    public <T> boolean indexExist(String indexName) {
        ExistExecutor executor = new ExistExecutor(this.getClient(), indexName);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    public <T> boolean indexExist(Class<T> clazz) {
        ExistExecutor executor = new ExistExecutor(this.getClient(), clazz);
        boolean result = (Boolean)executor.execute();
        executor = null;
        return result;
    }

    public <T> long count(Class<T> clazz) {
        CountExecutor executor = new CountExecutor(this.getClient(), clazz);
        long result = (Long)executor.execute();
        executor = null;
        return result;
    }

    public <T> List<T> findAll(Class<T> clazz) {
        SelectEntityExecutor executor = new SelectEntityExecutor(this.getClient(), clazz);
        List result = (List)executor.execute();
        executor = null;
        return result;
    }

    public <T> List<T> findByIds(Class<T> clazz, List<?> ids) {
        SelectEntityExecutor executor = new SelectEntityExecutor(this.getClient(), clazz, ids);
        List result = (List)executor.execute();
        executor = null;
        return result;
    }

    public <T> List<T> find(QueryCriteria queryCriteria, Class<T> clazz) {
        SelectEntityExecutor executor = new SelectEntityExecutor(this.getClient(), queryCriteria, clazz);
        List result = (List)executor.execute();
        executor = null;
        return result;
    }

    public <T> Page<T> findByPage(QueryCriteria queryCriteria, Class<T> clazz) {
        SelectEntityExecutor executor = new SelectEntityExecutor(this.getClient(), queryCriteria, clazz);
        Page result = (Page)executor.execute();
        executor = null;
        return result;
    }

    public <T> long count(QueryCriteria queryCriteria, Class<T> clazz) {
        CountExecutor executor = new CountExecutor(this.getClient(), queryCriteria, clazz);
        long result = (Long)executor.execute();
        executor = null;
        return result;
    }

    public <T> List<Map<String, Object>> aggregate(QueryCriteria queryCriteria, Class<T> clazz) {
        SelectEntityExecutor executor = new SelectEntityExecutor(this.getClient(), queryCriteria, clazz);
        List result = (List)executor.execute();
        executor = null;
        return result;
    }
}

