/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.rankeval.RankEvalRequest;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;

public final class RequestBuilder {
    static final XContentType REQUEST_BODY_CONTENT_TYPE = XContentType.JSON;
    private final String method;
    private final String endpoint;
    private final Map<String, String> parameters;
    private final HttpEntity entity;

    public RequestBuilder(String method, String endpoint, Map<String, String> parameters, HttpEntity entity) {
        this.method = Objects.requireNonNull(method, "method cannot be null");
        this.endpoint = Objects.requireNonNull(endpoint, "endpoint cannot be null");
        this.parameters = Objects.requireNonNull(parameters, "parameters cannot be null");
        this.entity = entity;
    }

    public String getMethod() {
        return this.method;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public String toString() {
        return "Request5{method='" + this.method + '\'' + ", endpoint='" + this.endpoint + '\'' + ", params=" + this.parameters + ", hasBody=" + (this.entity != null) + '}';
    }

    static RequestBuilder delete(DeleteRequest deleteRequest) {
        String endpoint = RequestBuilder.endpoint(deleteRequest.index(), deleteRequest.type(), deleteRequest.id());
        Params parameters = Params.builder();
        parameters.withRouting(deleteRequest.routing());
        parameters.withParent(deleteRequest.parent());
        parameters.withTimeout(deleteRequest.timeout());
        parameters.withVersion(deleteRequest.version());
        parameters.withVersionType(deleteRequest.versionType());
        parameters.withRefreshPolicy(deleteRequest.getRefreshPolicy());
        parameters.withWaitForActiveShards(deleteRequest.waitForActiveShards(), ActiveShardCount.DEFAULT);
        return new RequestBuilder("DELETE", endpoint, parameters.getParams(), null);
    }

    static RequestBuilder deleteIndex(DeleteIndexRequest deleteIndexRequest) {
        String endpoint = RequestBuilder.endpoint(deleteIndexRequest.indices());
        Params parameters = Params.builder();
        parameters.withTimeout(deleteIndexRequest.timeout());
        parameters.withMasterTimeout(deleteIndexRequest.masterNodeTimeout());
        parameters.withIndicesOptions(deleteIndexRequest.indicesOptions());
        return new RequestBuilder("DELETE", endpoint, parameters.getParams(), null);
    }

    static RequestBuilder openIndex(OpenIndexRequest openIndexRequest) {
        String endpoint = RequestBuilder.endpoint(openIndexRequest.indices(), "_open");
        Params parameters = Params.builder();
        parameters.withTimeout(openIndexRequest.timeout());
        parameters.withMasterTimeout(openIndexRequest.masterNodeTimeout());
        parameters.withWaitForActiveShards(openIndexRequest.waitForActiveShards(), ActiveShardCount.NONE);
        parameters.withIndicesOptions(openIndexRequest.indicesOptions());
        return new RequestBuilder("POST", endpoint, parameters.getParams(), null);
    }

    static RequestBuilder closeIndex(CloseIndexRequest closeIndexRequest) {
        String endpoint = RequestBuilder.endpoint(closeIndexRequest.indices(), "_close");
        Params parameters = Params.builder();
        parameters.withTimeout(closeIndexRequest.timeout());
        parameters.withMasterTimeout(closeIndexRequest.masterNodeTimeout());
        parameters.withIndicesOptions(closeIndexRequest.indicesOptions());
        return new RequestBuilder("POST", endpoint, parameters.getParams(), null);
    }

    static RequestBuilder createIndex(CreateIndexRequest createIndexRequest) throws IOException {
        String endpoint = RequestBuilder.endpoint(createIndexRequest.indices());
        Params parameters = Params.builder();
        parameters.withTimeout(createIndexRequest.timeout());
        parameters.withMasterTimeout(createIndexRequest.masterNodeTimeout());
        parameters.withWaitForActiveShards(createIndexRequest.waitForActiveShards(), ActiveShardCount.DEFAULT);
        parameters.withUpdateAllTypes(createIndexRequest.updateAllTypes());
        HttpEntity entity = RequestBuilder.createEntity((ToXContent)createIndexRequest, REQUEST_BODY_CONTENT_TYPE);
        return new RequestBuilder("PUT", endpoint, parameters.getParams(), entity);
    }

    static RequestBuilder updateAliases(IndicesAliasesRequest indicesAliasesRequest) throws IOException {
        Params parameters = Params.builder();
        parameters.withTimeout(indicesAliasesRequest.timeout());
        parameters.withMasterTimeout(indicesAliasesRequest.masterNodeTimeout());
        HttpEntity entity = RequestBuilder.createEntity((ToXContent)indicesAliasesRequest, REQUEST_BODY_CONTENT_TYPE);
        return new RequestBuilder("POST", "/_aliases", parameters.getParams(), entity);
    }

    static RequestBuilder putMapping(PutMappingRequest putMappingRequest) throws IOException {
        if (putMappingRequest.getConcreteIndex() != null) {
            throw new IllegalArgumentException("concreteIndex cannot be set on PutMapping requests made over the REST API");
        }
        String endpoint = RequestBuilder.endpoint(putMappingRequest.indices(), "_mapping", putMappingRequest.type());
        Params parameters = Params.builder();
        parameters.withTimeout(putMappingRequest.timeout());
        parameters.withMasterTimeout(putMappingRequest.masterNodeTimeout());
        parameters.withUpdateAllTypes(putMappingRequest.updateAllTypes());
        HttpEntity entity = RequestBuilder.createEntity((ToXContent)putMappingRequest, REQUEST_BODY_CONTENT_TYPE);
        return new RequestBuilder("PUT", endpoint, parameters.getParams(), entity);
    }

    static RequestBuilder refresh(RefreshRequest refreshRequest) {
        String[] indices = refreshRequest.indices() == null ? Strings.EMPTY_ARRAY : refreshRequest.indices();
        String endpoint = RequestBuilder.endpoint(indices, "_refresh");
        Params parameters = Params.builder();
        parameters.withIndicesOptions(refreshRequest.indicesOptions());
        return new RequestBuilder("POST", endpoint, parameters.getParams(), null);
    }

    static RequestBuilder flush(FlushRequest flushRequest) {
        String[] indices = flushRequest.indices() == null ? Strings.EMPTY_ARRAY : flushRequest.indices();
        String endpoint = RequestBuilder.endpoint(indices, "_flush");
        Params parameters = Params.builder();
        parameters.withIndicesOptions(flushRequest.indicesOptions());
        parameters.putParam("wait_if_ongoing", Boolean.toString(flushRequest.waitIfOngoing()));
        parameters.putParam("force", Boolean.toString(flushRequest.force()));
        return new RequestBuilder("POST", endpoint, parameters.getParams(), null);
    }

    static RequestBuilder forceMerge(ForceMergeRequest forceMergeRequest) {
        String[] indices = forceMergeRequest.indices() == null ? Strings.EMPTY_ARRAY : forceMergeRequest.indices();
        String endpoint = RequestBuilder.endpoint(indices, "_forcemerge");
        Params parameters = Params.builder();
        parameters.withIndicesOptions(forceMergeRequest.indicesOptions());
        parameters.putParam("max_num_segments", Integer.toString(forceMergeRequest.maxNumSegments()));
        parameters.putParam("only_expunge_deletes", Boolean.toString(forceMergeRequest.onlyExpungeDeletes()));
        parameters.putParam("flush", Boolean.toString(forceMergeRequest.flush()));
        return new RequestBuilder("POST", endpoint, parameters.getParams(), null);
    }

    static RequestBuilder clearCache(ClearIndicesCacheRequest clearIndicesCacheRequest) {
        String[] indices = clearIndicesCacheRequest.indices() == null ? Strings.EMPTY_ARRAY : clearIndicesCacheRequest.indices();
        String endpoint = RequestBuilder.endpoint(indices, "_cache/clear");
        Params parameters = Params.builder();
        parameters.withIndicesOptions(clearIndicesCacheRequest.indicesOptions());
        parameters.putParam("query", Boolean.toString(clearIndicesCacheRequest.queryCache()));
        parameters.putParam("fielddata", Boolean.toString(clearIndicesCacheRequest.fieldDataCache()));
        parameters.putParam("request", Boolean.toString(clearIndicesCacheRequest.requestCache()));
        parameters.putParam("fields", String.join((CharSequence)",", clearIndicesCacheRequest.fields()));
        return new RequestBuilder("POST", endpoint, parameters.getParams(), null);
    }

    static RequestBuilder info() {
        return new RequestBuilder("GET", "/", Collections.emptyMap(), null);
    }

    static RequestBuilder bulk(BulkRequest bulkRequest) throws IOException {
        Params parameters = Params.builder();
        parameters.withTimeout(bulkRequest.timeout());
        parameters.withRefreshPolicy(bulkRequest.getRefreshPolicy());
        XContentType bulkContentType = null;
        for (int i = 0; i < bulkRequest.numberOfActions(); ++i) {
            DocWriteRequest request = (DocWriteRequest)bulkRequest.requests().get(i);
            DocWriteRequest.OpType opType = request.opType();
            if (opType != DocWriteRequest.OpType.INDEX && opType != DocWriteRequest.OpType.CREATE) {
                if (opType != DocWriteRequest.OpType.UPDATE) continue;
                UpdateRequest updateRequest = (UpdateRequest)request;
                if (updateRequest.doc() != null) {
                    bulkContentType = RequestBuilder.enforceSameContentType(updateRequest.doc(), bulkContentType);
                }
                if (updateRequest.upsertRequest() == null) continue;
                bulkContentType = RequestBuilder.enforceSameContentType(updateRequest.upsertRequest(), bulkContentType);
                continue;
            }
            bulkContentType = RequestBuilder.enforceSameContentType((IndexRequest)request, bulkContentType);
        }
        if (bulkContentType == null) {
            bulkContentType = XContentType.JSON;
        }
        byte separator = bulkContentType.xContent().streamSeparator();
        ContentType requestContentType = RequestBuilder.createContentType(bulkContentType);
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        for (DocWriteRequest request : bulkRequest.requests()) {
            IndexRequest indexRequest;
            DocWriteRequest.OpType opType = request.opType();
            XContentBuilder metadata = XContentBuilder.builder((XContent)bulkContentType.xContent());
            Throwable var10 = null;
            try {
                VersionType versionType;
                metadata.startObject();
                metadata.startObject(opType.getLowercase());
                if (Strings.hasLength((String)request.index())) {
                    metadata.field("_index", request.index());
                }
                if (Strings.hasLength((String)request.type())) {
                    metadata.field("_type", request.type());
                }
                if (Strings.hasLength((String)request.id())) {
                    metadata.field("_id", request.id());
                }
                if (Strings.hasLength((String)request.routing())) {
                    metadata.field("routing", request.routing());
                }
                if (Strings.hasLength((String)request.parent())) {
                    metadata.field("parent", request.parent());
                }
                if (request.version() != -3L) {
                    metadata.field("version", request.version());
                }
                if ((versionType = request.versionType()) != VersionType.INTERNAL) {
                    if (versionType == VersionType.EXTERNAL) {
                        metadata.field("version_type", "external");
                    } else if (versionType == VersionType.EXTERNAL_GTE) {
                        metadata.field("version_type", "external_gte");
                    } else if (versionType == VersionType.FORCE) {
                        metadata.field("version_type", "force");
                    }
                }
                if (opType != DocWriteRequest.OpType.INDEX && opType != DocWriteRequest.OpType.CREATE) {
                    if (opType == DocWriteRequest.OpType.UPDATE) {
                        UpdateRequest updateRequest = (UpdateRequest)request;
                        if (updateRequest.retryOnConflict() > 0) {
                            metadata.field("retry_on_conflict", updateRequest.retryOnConflict());
                        }
                        if (updateRequest.fetchSource() != null) {
                            metadata.field("_source", (ToXContent)updateRequest.fetchSource());
                        }
                    }
                } else {
                    indexRequest = (IndexRequest)request;
                    if (Strings.hasLength((String)indexRequest.getPipeline())) {
                        metadata.field("pipeline", indexRequest.getPipeline());
                    }
                }
                metadata.endObject();
                metadata.endObject();
                BytesRef metadataSource = BytesReference.bytes((XContentBuilder)metadata).toBytesRef();
                content.write(metadataSource.bytes, metadataSource.offset, metadataSource.length);
                content.write(separator);
            }
            catch (Throwable var42) {
                var10 = var42;
                throw var42;
            }
            BytesRef source = null;
            if (opType != DocWriteRequest.OpType.INDEX && opType != DocWriteRequest.OpType.CREATE) {
                if (opType == DocWriteRequest.OpType.UPDATE) {
                    source = XContentHelper.toXContent((ToXContent)((UpdateRequest)request), (XContentType)bulkContentType, (boolean)false).toBytesRef();
                }
            } else {
                indexRequest = (IndexRequest)request;
                BytesReference indexSource = indexRequest.source();
                XContentType indexXContentType = indexRequest.getContentType();
                XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)indexSource, (XContentType)indexXContentType);
                Throwable var14 = null;
                try {
                    XContentBuilder builder = XContentBuilder.builder((XContent)bulkContentType.xContent());
                    Throwable var16 = null;
                    try {
                        builder.copyCurrentStructure(parser);
                        source = BytesReference.bytes((XContentBuilder)builder).toBytesRef();
                    }
                    catch (Throwable var38) {
                        var16 = var38;
                        throw var38;
                    }
                }
                catch (Throwable var40) {
                    var14 = var40;
                    throw var40;
                }
            }
            if (source == null) continue;
            content.write(source.bytes, source.offset, source.length);
            content.write(separator);
        }
        ByteArrayEntity entity = new ByteArrayEntity(content.toByteArray(), 0, content.size(), requestContentType);
        return new RequestBuilder("POST", "/_bulk", parameters.getParams(), (HttpEntity)entity);
    }

    static RequestBuilder exists(GetRequest getRequest) {
        RequestBuilder request = RequestBuilder.get(getRequest);
        return new RequestBuilder("HEAD", request.endpoint, request.parameters, null);
    }

    static RequestBuilder get(GetRequest getRequest) {
        String endpoint = RequestBuilder.endpoint(getRequest.index(), getRequest.type(), getRequest.id());
        Params parameters = Params.builder();
        parameters.withPreference(getRequest.preference());
        parameters.withRouting(getRequest.routing());
        parameters.withParent(getRequest.parent());
        parameters.withRefresh(getRequest.refresh());
        parameters.withRealtime(getRequest.realtime());
        parameters.withStoredFields(getRequest.storedFields());
        parameters.withVersion(getRequest.version());
        parameters.withVersionType(getRequest.versionType());
        parameters.withFetchSourceContext(getRequest.fetchSourceContext());
        return new RequestBuilder("GET", endpoint, parameters.getParams(), null);
    }

    static RequestBuilder multiGet(MultiGetRequest multiGetRequest) throws IOException {
        Params parameters = Params.builder();
        parameters.withPreference(multiGetRequest.preference());
        parameters.withRealtime(multiGetRequest.realtime());
        parameters.withRefresh(multiGetRequest.refresh());
        HttpEntity entity = RequestBuilder.createEntity((ToXContent)multiGetRequest, REQUEST_BODY_CONTENT_TYPE);
        return new RequestBuilder("POST", "/_mget", parameters.getParams(), entity);
    }

    static RequestBuilder index(IndexRequest indexRequest) {
        String method = Strings.hasLength((String)indexRequest.id()) ? "PUT" : "POST";
        boolean isCreate = indexRequest.opType() == DocWriteRequest.OpType.CREATE;
        String endpoint = RequestBuilder.endpoint(indexRequest.index(), indexRequest.type(), indexRequest.id(), isCreate ? "_create" : null);
        Params parameters = Params.builder();
        parameters.withRouting(indexRequest.routing());
        parameters.withParent(indexRequest.parent());
        parameters.withTimeout(indexRequest.timeout());
        parameters.withVersion(indexRequest.version());
        parameters.withVersionType(indexRequest.versionType());
        parameters.withPipeline(indexRequest.getPipeline());
        parameters.withRefreshPolicy(indexRequest.getRefreshPolicy());
        parameters.withWaitForActiveShards(indexRequest.waitForActiveShards(), ActiveShardCount.DEFAULT);
        BytesRef source = indexRequest.source().toBytesRef();
        ContentType contentType = RequestBuilder.createContentType(indexRequest.getContentType());
        ByteArrayEntity entity = new ByteArrayEntity(source.bytes, source.offset, source.length, contentType);
        return new RequestBuilder(method, endpoint, parameters.getParams(), (HttpEntity)entity);
    }

    static RequestBuilder ping() {
        return new RequestBuilder("HEAD", "/", Collections.emptyMap(), null);
    }

    static RequestBuilder update(UpdateRequest updateRequest) throws IOException {
        String endpoint = RequestBuilder.endpoint(updateRequest.index(), updateRequest.type(), updateRequest.id(), "_update");
        Params parameters = Params.builder();
        parameters.withRouting(updateRequest.routing());
        parameters.withParent(updateRequest.parent());
        parameters.withTimeout(updateRequest.timeout());
        parameters.withRefreshPolicy(updateRequest.getRefreshPolicy());
        parameters.withWaitForActiveShards(updateRequest.waitForActiveShards(), ActiveShardCount.DEFAULT);
        parameters.withDocAsUpsert(updateRequest.docAsUpsert());
        parameters.withFetchSourceContext(updateRequest.fetchSource());
        parameters.withRetryOnConflict(updateRequest.retryOnConflict());
        parameters.withVersion(updateRequest.version());
        parameters.withVersionType(updateRequest.versionType());
        XContentType xContentType = null;
        if (updateRequest.doc() != null) {
            xContentType = updateRequest.doc().getContentType();
        }
        if (updateRequest.upsertRequest() != null) {
            XContentType upsertContentType = updateRequest.upsertRequest().getContentType();
            if (xContentType != null && xContentType != upsertContentType) {
                throw new IllegalStateException("Update request cannot have different content types for doc [" + xContentType + "] and upsert [" + upsertContentType + "] documents");
            }
            xContentType = upsertContentType;
        }
        if (xContentType == null) {
            xContentType = Requests.INDEX_CONTENT_TYPE;
        }
        HttpEntity entity = RequestBuilder.createEntity((ToXContent)updateRequest, xContentType);
        return new RequestBuilder("POST", endpoint, parameters.getParams(), entity);
    }

    static RequestBuilder search(SearchRequest searchRequest) throws IOException {
        String endpoint = RequestBuilder.endpoint(searchRequest.indices(), searchRequest.types(), "_search");
        Params params = Params.builder();
        params.putParam("typed_keys", "true");
        params.withRouting(searchRequest.routing());
        params.withPreference(searchRequest.preference());
        params.withIndicesOptions(searchRequest.indicesOptions());
        params.putParam("search_type", searchRequest.searchType().name().toLowerCase(Locale.ROOT));
        if (searchRequest.requestCache() != null) {
            params.putParam("request_cache", Boolean.toString(searchRequest.requestCache()));
        }
        if (searchRequest.allowPartialSearchResults() != null) {
            params.putParam("allow_partial_search_results", Boolean.toString(searchRequest.allowPartialSearchResults()));
        }
        if (searchRequest.scroll() != null) {
            params.putParam("scroll", searchRequest.scroll().keepAlive());
        }
        HttpEntity entity = null;
        if (searchRequest.source() != null) {
            entity = RequestBuilder.createEntity((ToXContent)searchRequest.source(), REQUEST_BODY_CONTENT_TYPE);
        }
        return new RequestBuilder("POST", endpoint, params.getParams(), entity);
    }

    static RequestBuilder searchScroll(SearchScrollRequest searchScrollRequest) throws IOException {
        HttpEntity entity = RequestBuilder.createEntity((ToXContent)searchScrollRequest, REQUEST_BODY_CONTENT_TYPE);
        return new RequestBuilder("POST", "/_search/scroll", Collections.emptyMap(), entity);
    }

    static RequestBuilder clearScroll(ClearScrollRequest clearScrollRequest) throws IOException {
        HttpEntity entity = RequestBuilder.createEntity((ToXContent)clearScrollRequest, REQUEST_BODY_CONTENT_TYPE);
        return new RequestBuilder("DELETE", "/_search/scroll", Collections.emptyMap(), entity);
    }

    static RequestBuilder multiSearch(MultiSearchRequest multiSearchRequest) throws IOException {
        Params params = Params.builder();
        params.putParam("typed_keys", "true");
        if (multiSearchRequest.maxConcurrentSearchRequests() != 0) {
            params.putParam("max_concurrent_searches", Integer.toString(multiSearchRequest.maxConcurrentSearchRequests()));
        }
        XContent xContent = REQUEST_BODY_CONTENT_TYPE.xContent();
        byte[] source = MultiSearchRequest.writeMultiLineFormat((MultiSearchRequest)multiSearchRequest, (XContent)xContent);
        ByteArrayEntity entity = new ByteArrayEntity(source, RequestBuilder.createContentType(xContent.type()));
        return new RequestBuilder("POST", "/_msearch", params.getParams(), (HttpEntity)entity);
    }

    static RequestBuilder existsAlias(GetAliasesRequest getAliasesRequest) {
        Params params = Params.builder();
        params.withIndicesOptions(getAliasesRequest.indicesOptions());
        params.withLocal(getAliasesRequest.local());
        if (!(getAliasesRequest.indices() != null && getAliasesRequest.indices().length != 0 || getAliasesRequest.aliases() != null && getAliasesRequest.aliases().length != 0)) {
            throw new IllegalArgumentException("existsAlias requires at least an alias or an index");
        }
        String[] indices = getAliasesRequest.indices() == null ? Strings.EMPTY_ARRAY : getAliasesRequest.indices();
        String[] aliases = getAliasesRequest.aliases() == null ? Strings.EMPTY_ARRAY : getAliasesRequest.aliases();
        String endpoint = RequestBuilder.endpoint(indices, "_alias", aliases);
        return new RequestBuilder("HEAD", endpoint, params.getParams(), null);
    }

    static RequestBuilder rankEval(RankEvalRequest rankEvalRequest) throws IOException {
        String endpoint = RequestBuilder.endpoint(rankEvalRequest.indices(), Strings.EMPTY_ARRAY, "_rank_eval");
        Params params = Params.builder();
        params.withIndicesOptions(rankEvalRequest.indicesOptions());
        HttpEntity entity = RequestBuilder.createEntity((ToXContent)rankEvalRequest.getRankEvalSpec(), REQUEST_BODY_CONTENT_TYPE);
        return new RequestBuilder("GET", endpoint, params.getParams(), entity);
    }

    static RequestBuilder split(ResizeRequest resizeRequest) throws IOException {
        if (resizeRequest.getResizeType() != ResizeType.SPLIT) {
            throw new IllegalArgumentException("Wrong resize type [" + resizeRequest.getResizeType() + "] for indices split request");
        }
        return RequestBuilder.resize(resizeRequest);
    }

    static RequestBuilder shrink(ResizeRequest resizeRequest) throws IOException {
        if (resizeRequest.getResizeType() != ResizeType.SHRINK) {
            throw new IllegalArgumentException("Wrong resize type [" + resizeRequest.getResizeType() + "] for indices shrink request");
        }
        return RequestBuilder.resize(resizeRequest);
    }

    private static RequestBuilder resize(ResizeRequest resizeRequest) throws IOException {
        Params params = Params.builder();
        params.withTimeout(resizeRequest.timeout());
        params.withMasterTimeout(resizeRequest.masterNodeTimeout());
        params.withWaitForActiveShards(resizeRequest.getTargetIndexRequest().waitForActiveShards(), ActiveShardCount.DEFAULT);
        String endpoint = new EndpointBuilder().addPathPart(resizeRequest.getSourceIndex()).addPathPartAsIs("_" + resizeRequest.getResizeType().name().toLowerCase(Locale.ROOT)).addPathPart(resizeRequest.getTargetIndexRequest().index()).build();
        HttpEntity entity = RequestBuilder.createEntity((ToXContent)resizeRequest, REQUEST_BODY_CONTENT_TYPE);
        return new RequestBuilder("PUT", endpoint, params.getParams(), entity);
    }

    static RequestBuilder clusterPutSettings(ClusterUpdateSettingsRequest clusterUpdateSettingsRequest) throws IOException {
        Params parameters = Params.builder();
        parameters.withTimeout(clusterUpdateSettingsRequest.timeout());
        parameters.withMasterTimeout(clusterUpdateSettingsRequest.masterNodeTimeout());
        HttpEntity entity = RequestBuilder.createEntity((ToXContent)clusterUpdateSettingsRequest, REQUEST_BODY_CONTENT_TYPE);
        return new RequestBuilder("PUT", "/_cluster/settings", parameters.getParams(), entity);
    }

    static RequestBuilder rollover(RolloverRequest rolloverRequest) throws IOException {
        Params params = Params.builder();
        params.withTimeout(rolloverRequest.timeout());
        params.withMasterTimeout(rolloverRequest.masterNodeTimeout());
        params.withWaitForActiveShards(rolloverRequest.getCreateIndexRequest().waitForActiveShards(), ActiveShardCount.DEFAULT);
        if (rolloverRequest.isDryRun()) {
            params.putParam("dry_run", Boolean.TRUE.toString());
        }
        String endpoint = new EndpointBuilder().addPathPart(rolloverRequest.getAlias()).addPathPartAsIs("_rollover").addPathPart(rolloverRequest.getNewIndexName()).build();
        HttpEntity entity = RequestBuilder.createEntity((ToXContent)rolloverRequest, REQUEST_BODY_CONTENT_TYPE);
        return new RequestBuilder("POST", endpoint, params.getParams(), entity);
    }

    static RequestBuilder indicesExist(GetIndexRequest request) {
        if (request.indices() != null && request.indices().length != 0) {
            String endpoint = RequestBuilder.endpoint(request.indices(), "");
            Params params = Params.builder();
            params.withLocal(request.local());
            params.withHuman(request.humanReadable());
            params.withIndicesOptions(request.indicesOptions());
            params.withIncludeDefaults(request.includeDefaults());
            return new RequestBuilder("HEAD", endpoint, params.getParams(), null);
        }
        throw new IllegalArgumentException("indices are mandatory");
    }

    static RequestBuilder indexPutSettings(UpdateSettingsRequest updateSettingsRequest) throws IOException {
        Params parameters = Params.builder();
        parameters.withTimeout(updateSettingsRequest.timeout());
        parameters.withMasterTimeout(updateSettingsRequest.masterNodeTimeout());
        parameters.withIndicesOptions(updateSettingsRequest.indicesOptions());
        parameters.withPreserveExisting(updateSettingsRequest.isPreserveExisting());
        String[] indices = updateSettingsRequest.indices() == null ? Strings.EMPTY_ARRAY : updateSettingsRequest.indices();
        String endpoint = RequestBuilder.endpoint(indices, "_settings");
        HttpEntity entity = RequestBuilder.createEntity((ToXContent)updateSettingsRequest, REQUEST_BODY_CONTENT_TYPE);
        return new RequestBuilder("PUT", endpoint, parameters.getParams(), entity);
    }

    private static HttpEntity createEntity(ToXContent toXContent, XContentType xContentType) throws IOException {
        BytesRef source = XContentHelper.toXContent((ToXContent)toXContent, (XContentType)xContentType, (boolean)false).toBytesRef();
        return new ByteArrayEntity(source.bytes, source.offset, source.length, RequestBuilder.createContentType(xContentType));
    }

    static String endpoint(String index, String type, String id) {
        return new EndpointBuilder().addPathPart(index, type, id).build();
    }

    static String endpoint(String index, String type, String id, String endpoint) {
        return new EndpointBuilder().addPathPart(index, type, id).addPathPartAsIs(endpoint).build();
    }

    static String endpoint(String[] indices) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).build();
    }

    static String endpoint(String[] indices, String endpoint) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).addPathPartAsIs(endpoint).build();
    }

    static String endpoint(String[] indices, String[] types, String endpoint) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).addCommaSeparatedPathParts(types).addPathPartAsIs(endpoint).build();
    }

    static String endpoint(String[] indices, String endpoint, String[] suffixes) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).addPathPartAsIs(endpoint).addCommaSeparatedPathParts(suffixes).build();
    }

    static String endpoint(String[] indices, String endpoint, String type) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).addPathPartAsIs(endpoint).addPathPart(type).build();
    }

    @SuppressForbidden(reason="Only allowed place to convert a XContentType to a ContentType")
    public static ContentType createContentType(XContentType xContentType) {
        return ContentType.create((String)xContentType.mediaTypeWithoutParameters(), (Charset)null);
    }

    static XContentType enforceSameContentType(IndexRequest indexRequest, @Nullable XContentType xContentType) {
        XContentType requestContentType = indexRequest.getContentType();
        if (requestContentType != XContentType.JSON && requestContentType != XContentType.SMILE) {
            throw new IllegalArgumentException("Unsupported content-type found for request with content-type [" + requestContentType + "], only JSON and SMILE are supported");
        }
        if (xContentType == null) {
            return requestContentType;
        }
        if (requestContentType != xContentType) {
            throw new IllegalArgumentException("Mismatching content-type found for request with content-type [" + requestContentType + "], previous requests have content-type [" + xContentType + "]");
        }
        return xContentType;
    }

    static class Params {
        private final Map<String, String> params = new HashMap<String, String>();

        private Params() {
        }

        Params putParam(String key, String value) {
            if (Strings.hasLength((String)value) && this.params.putIfAbsent(key, value) != null) {
                throw new IllegalArgumentException("Request5 parameter [" + key + "] is already registered");
            }
            return this;
        }

        Params putParam(String key, TimeValue value) {
            return value != null ? this.putParam(key, value.getStringRep()) : this;
        }

        Params withDocAsUpsert(boolean docAsUpsert) {
            return docAsUpsert ? this.putParam("doc_as_upsert", Boolean.TRUE.toString()) : this;
        }

        Params withFetchSourceContext(FetchSourceContext fetchSourceContext) {
            if (fetchSourceContext != null) {
                if (!fetchSourceContext.fetchSource()) {
                    this.putParam("_source", Boolean.FALSE.toString());
                }
                if (fetchSourceContext.includes() != null && fetchSourceContext.includes().length > 0) {
                    this.putParam("_source_include", String.join((CharSequence)",", fetchSourceContext.includes()));
                }
                if (fetchSourceContext.excludes() != null && fetchSourceContext.excludes().length > 0) {
                    this.putParam("_source_exclude", String.join((CharSequence)",", fetchSourceContext.excludes()));
                }
            }
            return this;
        }

        Params withMasterTimeout(TimeValue masterTimeout) {
            return this.putParam("master_timeout", masterTimeout);
        }

        Params withParent(String parent) {
            return this.putParam("parent", parent);
        }

        Params withPipeline(String pipeline) {
            return this.putParam("pipeline", pipeline);
        }

        Params withPreference(String preference) {
            return this.putParam("preference", preference);
        }

        Params withRealtime(boolean realtime) {
            return !realtime ? this.putParam("realtime", Boolean.FALSE.toString()) : this;
        }

        Params withRefresh(boolean refresh) {
            return refresh ? this.withRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE) : this;
        }

        Params withRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
            return refreshPolicy != WriteRequest.RefreshPolicy.NONE ? this.putParam("refresh", refreshPolicy.getValue()) : this;
        }

        Params withRetryOnConflict(int retryOnConflict) {
            return retryOnConflict > 0 ? this.putParam("retry_on_conflict", String.valueOf(retryOnConflict)) : this;
        }

        Params withRouting(String routing) {
            return this.putParam("routing", routing);
        }

        Params withStoredFields(String[] storedFields) {
            return storedFields != null && storedFields.length > 0 ? this.putParam("stored_fields", String.join((CharSequence)",", storedFields)) : this;
        }

        Params withTimeout(TimeValue timeout) {
            return this.putParam("timeout", timeout);
        }

        Params withUpdateAllTypes(boolean updateAllTypes) {
            return updateAllTypes ? this.putParam("update_all_types", Boolean.TRUE.toString()) : this;
        }

        Params withVersion(long version) {
            return version != -3L ? this.putParam("version", Long.toString(version)) : this;
        }

        Params withVersionType(VersionType versionType) {
            return versionType != VersionType.INTERNAL ? this.putParam("version_type", versionType.name().toLowerCase(Locale.ROOT)) : this;
        }

        Params withWaitForActiveShards(ActiveShardCount currentActiveShardCount, ActiveShardCount defaultActiveShardCount) {
            return currentActiveShardCount != null && currentActiveShardCount != defaultActiveShardCount ? this.putParam("wait_for_active_shards", currentActiveShardCount.toString().toLowerCase(Locale.ROOT)) : this;
        }

        Params withIndicesOptions(IndicesOptions indicesOptions) {
            String expandWildcards;
            this.putParam("ignore_unavailable", Boolean.toString(indicesOptions.ignoreUnavailable()));
            this.putParam("allow_no_indices", Boolean.toString(indicesOptions.allowNoIndices()));
            if (!indicesOptions.expandWildcardsOpen() && !indicesOptions.expandWildcardsClosed()) {
                expandWildcards = "none";
            } else {
                StringJoiner joiner = new StringJoiner(",");
                if (indicesOptions.expandWildcardsOpen()) {
                    joiner.add("open");
                }
                if (indicesOptions.expandWildcardsClosed()) {
                    joiner.add("closed");
                }
                expandWildcards = joiner.toString();
            }
            this.putParam("expand_wildcards", expandWildcards);
            return this;
        }

        Params withHuman(boolean human) {
            if (human) {
                this.putParam("human", Boolean.toString(human));
            }
            return this;
        }

        Params withLocal(boolean local) {
            if (local) {
                this.putParam("local", Boolean.toString(local));
            }
            return this;
        }

        Params withFlatSettings(boolean flatSettings) {
            return flatSettings ? this.putParam("flat_settings", Boolean.TRUE.toString()) : this;
        }

        Params withIncludeDefaults(boolean includeDefaults) {
            return includeDefaults ? this.putParam("include_defaults", Boolean.TRUE.toString()) : this;
        }

        Params withPreserveExisting(boolean preserveExisting) {
            return preserveExisting ? this.putParam("preserve_existing", Boolean.TRUE.toString()) : this;
        }

        Map<String, String> getParams() {
            return Collections.unmodifiableMap(this.params);
        }

        static Params builder() {
            return new Params();
        }
    }

    static class EndpointBuilder {
        private final StringJoiner joiner = new StringJoiner("/", "/", "");

        EndpointBuilder() {
        }

        EndpointBuilder addPathPart(String ... parts) {
            String[] var2 = parts;
            int var3 = parts.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                String part = var2[var4];
                if (!Strings.hasLength((String)part)) continue;
                this.joiner.add(EndpointBuilder.encodePart(part));
            }
            return this;
        }

        EndpointBuilder addCommaSeparatedPathParts(String[] parts) {
            this.addPathPart(String.join((CharSequence)",", parts));
            return this;
        }

        EndpointBuilder addPathPartAsIs(String part) {
            if (Strings.hasLength((String)part)) {
                this.joiner.add(part);
            }
            return this;
        }

        String build() {
            return this.joiner.toString();
        }

        private static String encodePart(String pathPart) {
            try {
                URI uri = new URI(null, null, null, -1, "/" + pathPart, null, null);
                return uri.getRawPath().substring(1).replaceAll("/", "%2F");
            }
            catch (URISyntaxException var2) {
                throw new IllegalArgumentException("Path part [" + pathPart + "] couldn't be encoded", var2);
            }
        }
    }
}

