/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.client;

import com.xphsc.elasticsearch.core.client.RequestBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.http.Header;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;

public class RestHighLevelClientBulider
extends RestHighLevelClient {
    public RestHighLevelClientBulider(RestClientBuilder restClientBuilder) {
        super(restClientBuilder);
    }

    protected RestHighLevelClientBulider(RestClientBuilder restClientBuilder, List<NamedXContentRegistry.Entry> namedXContentEntries) {
        super(restClientBuilder, namedXContentEntries);
    }

    protected RestHighLevelClientBulider(RestClient restClient, CheckedConsumer<RestClient, IOException> doClose, List<NamedXContentRegistry.Entry> namedXContentEntries) {
        super(restClient, doClose, namedXContentEntries);
    }

    public final SearchResponse searchBuilder(SearchRequest searchRequest, Header ... headers) throws IOException {
        return (SearchResponse)this.performRequestAndParseEntityBuilder(searchRequest, RequestBuilder::search, SearchResponse::fromXContent, Collections.emptySet(), headers);
    }

    protected final <Req extends ActionRequest, Resp> Resp performRequestAndParseEntityBuilder(Req request, CheckedFunction<Req, RequestBuilder, IOException> requestConverter, CheckedFunction<XContentParser, Resp, IOException> entityParser, Set<Integer> ignores, Header ... headers) throws IOException {
        return this.performRequest5(request, requestConverter, response -> this.parseEntity(response.getEntity(), entityParser), ignores, headers);
    }

    protected final <Req extends ActionRequest, Resp> Resp performRequest5(Req request, CheckedFunction<Req, RequestBuilder, IOException> requestConverter, CheckedFunction<Response, Resp, IOException> responseConverter, Set<Integer> ignores, Header ... headers) throws IOException {
        Response response;
        ActionRequestValidationException validationException = request.validate();
        if (validationException != null) {
            throw validationException;
        }
        RequestBuilder req = (RequestBuilder)requestConverter.apply(request);
        try {
            response = this.getLowLevelClient().performRequest(req.getMethod(), req.getEndpoint(), new HashMap(), req.getEntity(), headers);
        }
        catch (ResponseException e) {
            if (ignores.contains(e.getResponse().getStatusLine().getStatusCode())) {
                try {
                    return (Resp)responseConverter.apply((Object)e.getResponse());
                }
                catch (Exception innerException) {
                    throw this.parseResponseException(e);
                }
            }
            throw this.parseResponseException(e);
        }
        try {
            return (Resp)responseConverter.apply((Object)response);
        }
        catch (Exception e) {
            throw new IOException("Unable to parse response body for " + response, e);
        }
    }
}

