/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.Executor;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import org.apache.http.Header;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.common.unit.TimeValue;

public abstract class AbstractExecutor<T>
implements Executor<T> {
    protected final RestHighLevelClientBulider client;
    protected long requestRimeout = 1L;

    protected AbstractExecutor(RestHighLevelClientBulider client) {
        this.client = client;
    }

    @Override
    public T execute() throws ElasticsearchException {
        return this.doExecute();
    }

    protected abstract T doExecute() throws ElasticsearchException;

    protected boolean indexExist(String indexName) {
        String newIndexName = "";
        if (Strings.isNotBlank(indexName)) {
            newIndexName = indexName;
        }
        GetIndexRequest request = new GetIndexRequest();
        request.indices(new String[]{newIndexName});
        request.local(false);
        request.humanReadable(true);
        request.masterNodeTimeout(TimeValue.timeValueMinutes((long)5L));
        boolean exists = false;
        try {
            exists = this.client.indices().exists(request, new Header[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return exists;
    }
}

