/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.entity.PersistentEntity;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.query.QueryCriteria;
import com.xphsc.elasticsearch.core.transform.DynamicEntity;
import java.io.IOException;
import org.apache.http.Header;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class CountExecutor
extends AbstractExecutor<Long> {
    private Class clazz;
    private QueryCriteria constructor;

    public CountExecutor(RestHighLevelClientBulider client, Class clazz) {
        super(client);
        this.clazz = clazz;
    }

    public CountExecutor(RestHighLevelClientBulider client, QueryCriteria constructor, Class clazz) {
        super(client);
        this.clazz = clazz;
        this.constructor = constructor;
    }

    @Override
    protected Long doExecute() throws ElasticsearchException {
        PersistentEntity persistentEntity = DynamicEntity.getPersistentEntityFor(this.clazz);
        SearchRequest request = new SearchRequest();
        request.indices(new String[]{persistentEntity.getIndexName()});
        request.types(new String[]{persistentEntity.getIndexType()});
        SearchSourceBuilder builder = new SearchSourceBuilder();
        if (null != this.constructor) {
            builder.query(this.constructor.listBuilders());
        }
        request.source(builder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.client.search(request, new Header[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SearchHits hits = searchResponse.getHits();
        return hits.getTotalHits();
    }
}

