/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.entity.PersistentEntity;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.transform.DynamicEntity;
import com.xphsc.elasticsearch.util.Asserts;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import org.apache.http.Header;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;

public class CreateExecutor
extends AbstractExecutor<Boolean> {
    private String indexName;
    private Class<?> clazz;
    private String alias;
    private int shards;
    private int replicas;
    private String refreshInterval;
    private String indexStoreType;
    private int maxResult;

    public CreateExecutor(RestHighLevelClientBulider client, String indexName) {
        super(client);
        this.indexName = indexName;
    }

    public CreateExecutor(RestHighLevelClientBulider client, Class<?> clazz) {
        super(client);
        this.clazz = clazz;
    }

    public CreateExecutor(RestHighLevelClientBulider client, String indexName, String alias, int shards, int replicas, String refreshInterval, String indexStoreType) {
        super(client);
        this.indexName = indexName;
        this.alias = alias;
        this.shards = shards;
        this.replicas = replicas;
        this.refreshInterval = refreshInterval;
        this.indexStoreType = indexStoreType;
    }

    public CreateExecutor(RestHighLevelClientBulider client, String indexName, String alias, int shards, int replicas, int maxResult, String refreshInterval, String indexStoreType) {
        super(client);
        this.indexName = indexName;
        this.alias = alias;
        this.shards = shards;
        this.replicas = replicas;
        this.refreshInterval = refreshInterval;
        this.indexStoreType = indexStoreType;
        this.maxResult = maxResult;
    }

    @Override
    protected Boolean doExecute() throws ElasticsearchException {
        String newIndexName = "";
        CreateIndexRequest request = null;
        Settings.Builder settings = Settings.builder();
        if (Strings.isNotBlank(this.indexName)) {
            newIndexName = this.indexName;
        }
        if (this.clazz != null) {
            PersistentEntity entity = DynamicEntity.getPersistentEntityFor(this.clazz);
            newIndexName = entity.getIndexName();
            if (entity.getShards() != 0) {
                this.shards = entity.getShards();
            }
            if (entity.getReplicas() != 0) {
                this.replicas = entity.getReplicas();
            }
            if (entity.getMaxResult() > 10000) {
                this.maxResult = entity.getMaxResult();
            }
            if (Strings.isNotBlank(entity.getRefreshInterval())) {
                this.refreshInterval = entity.getRefreshInterval();
            }
            if (Strings.isNotBlank(entity.getIndexStoreType())) {
                this.refreshInterval = entity.getIndexStoreType();
            }
            if (Strings.isNotBlank(entity.getAlias())) {
                this.alias = entity.getAlias();
            }
        }
        Asserts.isTrue(!this.indexExist(newIndexName), "index already exists");
        if (this.shards != 0) {
            settings.put("index.number_of_shards", this.shards);
        }
        if (this.replicas != 0) {
            settings.put("index.number_of_replicas", this.replicas);
        }
        if (this.maxResult > 10000) {
            settings.put("index.max_result_window", this.maxResult);
        }
        if (Strings.isNotBlank(this.refreshInterval)) {
            settings.put("index.refresh_interval", this.refreshInterval);
        }
        if (Strings.isNotBlank(this.indexStoreType)) {
            settings.put("index.store.type", this.indexStoreType);
        }
        try {
            request = new CreateIndexRequest(newIndexName.toLowerCase()).settings(settings);
            if (Strings.isNotEmpty(this.alias)) {
                request.alias(new Alias(this.alias));
            }
            request.timeout(TimeValue.timeValueMinutes((long)this.requestRimeout));
            request.masterNodeTimeout(TimeValue.timeValueMinutes((long)this.requestRimeout));
            return this.client.indices().create(request, new Header[0]).isAcknowledged();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

