/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.entity.PersistentEntity;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.transform.DynamicEntity;
import com.xphsc.elasticsearch.util.Beans;
import com.xphsc.elasticsearch.util.Collects;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.common.unit.TimeValue;

public class DeleteEntityExecutor<T>
extends AbstractExecutor<Object> {
    private String id;
    private T entity;
    private List<String> ids;
    private Class<?> clazz;

    public DeleteEntityExecutor(RestHighLevelClientBulider client, Class<?> clazz, Serializable id) {
        super(client);
        this.id = id.toString();
        this.clazz = clazz;
    }

    public DeleteEntityExecutor(RestHighLevelClientBulider client, Class<T> clazz, List<String> ids) {
        super(client);
        this.ids = ids;
        this.clazz = clazz;
    }

    public DeleteEntityExecutor(RestHighLevelClientBulider client, T entity) {
        super(client);
        this.entity = entity;
    }

    @Override
    protected Object doExecute() throws ElasticsearchException {
        PersistentEntity persistentEntity = null;
        if (this.entity != null) {
            persistentEntity = DynamicEntity.getPersistentEntityFor(this.entity.getClass());
        }
        if (this.clazz != null) {
            persistentEntity = DynamicEntity.getPersistentEntityFor(this.clazz);
        }
        DeleteRequest deleteRequest = new DeleteRequest();
        deleteRequest.index(persistentEntity.getIndexName());
        deleteRequest.type(persistentEntity.getIndexType());
        deleteRequest.timeout(TimeValue.timeValueMinutes((long)this.requestRimeout));
        if (Strings.isNotBlank(this.id)) {
            deleteRequest.id(this.id);
        }
        if (Collects.isNotEmpty(this.ids)) {
            DeleteResponse deleteResponse = null;
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (String id : this.ids) {
                deleteRequest.id(id);
                try {
                    deleteResponse = this.client.delete(deleteRequest, new Header[0]);
                    result.add(deleteResponse.status().getStatus());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return result.size();
        }
        String id = Beans.getIdValue(this.entity);
        if (!Strings.isNotEmpty(id)) {
            throw new ElasticsearchException("@Id should be defined.");
        }
        deleteRequest.id(id);
        try {
            return this.client.delete(deleteRequest, new Header[0]).status().getStatus();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

