/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.entity.PersistentEntity;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.transform.DynamicEntity;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import org.apache.http.Header;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.common.unit.TimeValue;

public class DeleteExecutor
extends AbstractExecutor<Boolean> {
    private String indexName;
    private Class clazz;

    public DeleteExecutor(RestHighLevelClientBulider client, String indexName) {
        super(client);
        this.indexName = indexName;
    }

    public DeleteExecutor(RestHighLevelClientBulider client, Class clazz) {
        super(client);
        this.clazz = clazz;
    }

    @Override
    protected Boolean doExecute() throws ElasticsearchException {
        String newIndexName = "";
        if (Strings.isNotBlank(this.indexName)) {
            newIndexName = this.indexName;
        } else {
            PersistentEntity entity = DynamicEntity.getPersistentEntityFor(this.clazz);
            newIndexName = entity.getIndexName();
        }
        try {
            DeleteIndexRequest request = new DeleteIndexRequest(newIndexName.toLowerCase());
            request.timeout(TimeValue.timeValueMinutes((long)this.requestRimeout));
            return this.client.indices().delete(request, new Header[0]).isAcknowledged();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

