/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.entity.PersistentEntity;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.transform.DynamicEntity;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import org.apache.http.Header;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.common.unit.TimeValue;

public class ExistExecutor
extends AbstractExecutor<Boolean> {
    private String indexName;
    private Class<?> clazz;

    public ExistExecutor(RestHighLevelClientBulider client, String indexName) {
        super(client);
        this.indexName = indexName;
    }

    public ExistExecutor(RestHighLevelClientBulider client, Class<?> clazz) {
        super(client);
        this.clazz = clazz;
    }

    @Override
    protected Boolean doExecute() throws ElasticsearchException {
        String newIndexName = "";
        if (Strings.isNotBlank(this.indexName)) {
            newIndexName = this.indexName;
        } else {
            PersistentEntity entity = DynamicEntity.getPersistentEntityFor(this.clazz);
            newIndexName = entity.getIndexName();
        }
        boolean exists = false;
        GetIndexRequest request = new GetIndexRequest();
        request.indices(new String[]{newIndexName});
        request.masterNodeTimeout(TimeValue.timeValueMinutes((long)this.requestRimeout));
        try {
            exists = this.client.indices().exists(request, new Header[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return exists;
    }
}

