/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.alibaba.fastjson.JSON;
import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.entity.PersistentEntity;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.transform.DynamicEntity;
import com.xphsc.elasticsearch.util.Beans;
import com.xphsc.elasticsearch.util.ElasticsearchHelpper;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import java.io.Serializable;
import org.apache.http.Header;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;

public class GetEntityExecutor<T>
extends AbstractExecutor<T> {
    private String id;
    private T entity;
    private Class<?> clazz;

    public GetEntityExecutor(RestHighLevelClientBulider client, T entity) {
        super(client);
        this.entity = entity;
    }

    public GetEntityExecutor(RestHighLevelClientBulider client, Class<?> clazz, Serializable id) {
        super(client);
        this.id = id.toString();
        this.clazz = clazz;
    }

    @Override
    protected T doExecute() throws ElasticsearchException {
        PersistentEntity persistentEntity = null;
        persistentEntity = this.entity != null ? DynamicEntity.getPersistentEntityFor(this.entity.getClass()) : DynamicEntity.getPersistentEntityFor(this.clazz);
        GetRequest getRequest = new GetRequest();
        getRequest.index(persistentEntity.getIndexName());
        getRequest.type(persistentEntity.getIndexType());
        if (Strings.isNotBlank(this.id)) {
            getRequest.id(this.id);
        } else {
            String id = Beans.getIdValue(this.entity);
            if (!Strings.isNotEmpty(id)) {
                throw new ElasticsearchException("@Id should be defined.");
            }
            getRequest.id(id);
        }
        try {
            GetResponse getResponse = this.client.get(getRequest, new Header[0]);
            Class<?> entityObject = this.entity != null ? this.entity.getClass() : this.clazz;
            return (T)JSON.parseObject((String)ElasticsearchHelpper.toJsonWithId(getResponse.getSourceAsString(), Beans.getIdName(entityObject), getRequest.id()), entityObject);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

