/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.alibaba.fastjson.annotation.JSONField;
import com.xphsc.elasticsearch.annotations.Child;
import com.xphsc.elasticsearch.annotations.Id;
import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.entity.PersistentEntity;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.executor.CreateExecutor;
import com.xphsc.elasticsearch.core.executor.ExistExecutor;
import com.xphsc.elasticsearch.core.transform.DynamicEntity;
import com.xphsc.elasticsearch.util.ElasticsearchHelpper;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.http.Header;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public class PutExecutor
extends AbstractExecutor<Boolean> {
    private Class<?> clazz;

    public PutExecutor(RestHighLevelClientBulider client, Class<?> clazz) {
        super(client);
        this.clazz = clazz;
    }

    @Override
    protected Boolean doExecute() throws ElasticsearchException {
        try {
            ExistExecutor executor = new ExistExecutor(this.client, this.clazz);
            boolean result = (Boolean)executor.execute();
            return !result ? this.client.indices().putMapping(this.reflectMapping(this.clazz), new Header[0]).isAcknowledged() : false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private PutMappingRequest reflectMapping(Class clazz) {
        try {
            PersistentEntity entity = DynamicEntity.getPersistentEntityFor(clazz);
            if (entity.isAutoCreateIndex()) {
                CreateExecutor executor = new CreateExecutor(this.client, entity.getIndexName(), entity.getAlias(), entity.getShards(), entity.getReplicas(), entity.getMaxResult(), entity.getRefreshInterval(), entity.getIndexStoreType());
                executor.execute();
            }
            XContentBuilder mapping = null;
            try {
                mapping = XContentFactory.jsonBuilder().startObject().startObject("properties");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                mapping = this.iterClass(clazz, mapping);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                mapping.endObject().endObject();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return Requests.putMappingRequest((String[])new String[]{entity.getIndexName()}).type(entity.getIndexType()).source(mapping);
        }
        catch (ElasticsearchException e) {
            throw new ElasticsearchException(e);
        }
    }

    private XContentBuilder iterClass(Class clazz, XContentBuilder mapping) throws IOException {
        Field[] declaredFields = null;
        try {
            declaredFields = clazz.getClassLoader().loadClass(clazz.getName()).getDeclaredFields();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        for (Field declaredField : declaredFields) {
            Type genericType;
            com.xphsc.elasticsearch.annotations.Field annotation = declaredField.getAnnotation(com.xphsc.elasticsearch.annotations.Field.class);
            JSONField jsonField = declaredField.getAnnotation(JSONField.class);
            Child child = declaredField.getAnnotation(Child.class);
            if (null != child && !"void".equals(child.childClass().getName())) {
                if (null != jsonField && Strings.isNotEmpty(jsonField.name())) {
                    mapping.startObject(jsonField.name());
                } else {
                    mapping.startObject(declaredField.getName());
                }
                mapping.startObject("properties");
                mapping = this.iterClass(child.childClass(), mapping);
                mapping.endObject();
                mapping.endObject();
                continue;
            }
            Id idAnno = declaredField.getAnnotation(Id.class);
            if (null != idAnno) continue;
            String typeName = declaredField.getType().getName();
            if (declaredField.getType() == List.class && (genericType = declaredField.getGenericType()) instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                Class genericClazz = (Class)pt.getActualTypeArguments()[0];
                typeName = genericClazz.getName();
            }
            if (declaredField.getType() == String.class) {
                typeName = "keyword";
            }
            if (null != jsonField && Strings.isNotEmpty(jsonField.name())) {
                mapping.startObject(jsonField.name()).field("type", ElasticsearchHelpper.format(typeName));
            } else {
                mapping.startObject(declaredField.getName()).field("type", ElasticsearchHelpper.format(typeName));
            }
            mapping = this.getMapping(mapping, annotation);
            mapping.endObject();
        }
        return mapping;
    }

    private XContentBuilder getMapping(XContentBuilder mapping, com.xphsc.elasticsearch.annotations.Field annotation) throws IOException {
        if (null != annotation) {
            if (annotation.textAndKeyword()) {
                mapping.startObject("fields").startObject("keyword");
                mapping.field("type", "keyword");
                mapping.endObject().endObject();
            }
            if (annotation.fieldData()) {
                mapping.field("fielddata", true);
            }
            if (!annotation.docValues()) {
                mapping.field("doc_values", false);
            }
            if (Strings.isNotBlank(annotation.format())) {
                mapping.field("format", annotation.format());
            }
            if (!"trict".equals(annotation.dynamic())) {
                mapping.field("dynamic", Boolean.valueOf(annotation.dynamic()));
            }
            mapping.field("index", annotation.index());
            mapping.field("store", annotation.store());
        }
        return mapping;
    }
}

