/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.entity.PersistentEntity;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.transform.DynamicEntity;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import org.apache.http.Header;
import org.elasticsearch.client.Requests;

public class RefreshExecutor
extends AbstractExecutor<Boolean> {
    private String indexName;
    private Class<?> entity;

    public RefreshExecutor(RestHighLevelClientBulider client, String indexName) {
        super(client);
        this.indexName = indexName;
    }

    public RefreshExecutor(RestHighLevelClientBulider client, Class<?> entity) {
        super(client);
        this.entity = entity;
    }

    @Override
    protected Boolean doExecute() throws ElasticsearchException {
        PersistentEntity clazz = DynamicEntity.getPersistentEntityFor(this.entity);
        String newIndexName = Strings.isNotEmpty(this.indexName) ? this.indexName : clazz.getIndexName();
        try {
            return this.client.indices().refresh(Requests.refreshRequest((String[])new String[]{newIndexName}), new Header[0]).isFragment();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

