/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.entity.PersistentEntity;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.executor.RefreshExecutor;
import com.xphsc.elasticsearch.core.query.QueryCriteria;
import com.xphsc.elasticsearch.core.transform.DynamicEntity;
import com.xphsc.elasticsearch.util.Asserts;
import com.xphsc.elasticsearch.util.Collects;
import com.xphsc.elasticsearch.util.ElasticsearchHelpper;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class SelectEntityExecutor<T>
extends AbstractExecutor<T> {
    private Class<?> entity;
    private QueryCriteria constructor;
    private boolean isPage = false;
    private short queryMaxSize;
    private List<Object> ids;

    public SelectEntityExecutor(RestHighLevelClientBulider client, QueryCriteria criteria, Class<?> entity) {
        super(client);
        this.entity = entity;
        this.constructor = criteria;
    }

    public SelectEntityExecutor(RestHighLevelClientBulider client, Class<?> entity) {
        super(client);
        this.entity = entity;
    }

    public SelectEntityExecutor(RestHighLevelClientBulider client, Class<?> entity, List<Object> ids) {
        super(client);
        this.entity = entity;
        this.ids = ids;
    }

    @Override
    protected T doExecute() throws ElasticsearchException {
        PersistentEntity persistentEntity = DynamicEntity.getPersistentEntityFor(this.entity);
        SearchRequest request = new SearchRequest();
        request.indices(new String[]{persistentEntity.getIndexName()});
        request.types(new String[]{persistentEntity.getIndexType()});
        SearchSourceBuilder builder = new SearchSourceBuilder();
        SearchResponse searchResponse = null;
        if (null != this.constructor) {
            this.queryMaxSize = this.constructor.queryMaxSize;
            ValuesSourceAggregationBuilder aggregation = null;
            if (this.constructor.isRefresh) {
                String[] executor = new RefreshExecutor(this.client, this.entity);
                executor.execute();
            }
            if (Strings.isNotBlank(this.constructor.statBy) || this.constructor.aggregationCriteria != null) {
                if (Strings.isNotBlank(this.constructor.statBy)) {
                    aggregation = AggregationBuilders.terms((String)"aggs").field(this.constructor.statBy);
                    builder = builder.aggregation((AggregationBuilder)aggregation);
                }
                if (this.constructor.aggregationCriteria != null) {
                    Asserts.notNull(this.constructor.aggregationCriteria.aggregationBuilder(), "\nAggregation must not be empty");
                    builder.aggregation(this.constructor.aggregationCriteria.aggregationBuilder());
                }
                if (null != this.constructor.orderByAsc) {
                    for (String asc : this.constructor.orderByAsc) {
                        builder.sort(asc, SortOrder.ASC);
                    }
                }
                if (null != this.constructor.orderBydesc) {
                    for (String desc : this.constructor.orderBydesc) {
                        builder.sort(desc, SortOrder.DESC);
                    }
                }
                builder.query(this.constructor.listBuilders());
                request.source(builder);
                try {
                    searchResponse = this.client.search(request, new Header[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Aggregations aggregations = searchResponse.getAggregations();
                SearchHits hits = searchResponse.getHits();
                return (T)ElasticsearchHelpper.formatAggAsMap(hits, aggregations, this.entity, this.constructor.aggregationCriteria != null ? this.constructor.aggregationCriteria.aggregationBuilder().getName() : aggregation.getName());
            }
            int size = 0;
            int from = 0;
            if (null != this.constructor.orderByAsc) {
                for (String asc : this.constructor.orderByAsc) {
                    builder.sort(asc, SortOrder.ASC);
                }
            }
            if (null != this.constructor.orderBydesc) {
                for (String desc : this.constructor.orderBydesc) {
                    builder.sort(desc, SortOrder.DESC);
                }
            }
            if (null != this.constructor.highlightBuilder) {
                builder.highlighter(this.constructor.highlightBuilder);
            }
            if (this.constructor.pageQuery != null) {
                this.isPage = true;
                if (Strings.isNotBlank(String.valueOf(this.constructor.pageQuery.getPageNum())) && this.constructor.pageQuery.getPageNum() > 0) {
                    size = this.constructor.pageQuery.pageSize;
                    from = (this.constructor.pageQuery.getPageNum() - 1) * size;
                    builder.size(size);
                    builder.from(from);
                } else {
                    Asserts.isTrue(this.constructor.pageQuery.getOffset() >= 0, "Offset must be greater than or equal to 0");
                    Asserts.isTrue(this.constructor.pageQuery.getLimit() > 0, "Limit must be greater than 0");
                    size = this.constructor.pageQuery.getLimit();
                    from = this.constructor.pageQuery.getOffset();
                    builder.size(size);
                    builder.from(from);
                }
            } else {
                builder.size((int)this.queryMaxSize);
            }
            builder.query(this.constructor.listBuilders());
            builder.timeout(TimeValue.timeValueMinutes((long)this.requestRimeout));
            builder.explain(Boolean.valueOf(false));
            request.source(builder);
            try {
                searchResponse = this.client.searchBuilder(request, new Header[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            SearchHits hits = searchResponse.getHits();
            if (this.isPage) {
                return (T)ElasticsearchHelpper.formatToPageByEntity(hits, this.entity, this.constructor.queryMaxSize, from, size);
            }
            return (T)ElasticsearchHelpper.formatToEntity(hits, this.entity);
        }
        this.constructor = new QueryCriteria();
        if (Collects.isNotEmpty(this.ids)) {
            QueryCriteria.Criteria criteria = this.constructor.createCriteria();
            criteria.in(this.ids);
            builder.query(this.constructor.listBuilders());
        } else {
            builder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        request.source(builder);
        try {
            searchResponse = this.client.searchBuilder(request, new Header[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SearchHits hits = searchResponse.getHits();
        return (T)ElasticsearchHelpper.formatToEntity(hits, this.entity);
    }
}

