/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.alibaba.fastjson.JSON;
import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.entity.PersistentEntity;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.transform.DynamicEntity;
import com.xphsc.elasticsearch.util.Beans;
import com.xphsc.elasticsearch.util.Collects;
import com.xphsc.elasticsearch.util.ElasticsearchHelpper;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.Header;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;

public class UpdateEntityExecutor<T>
extends AbstractExecutor<Object> {
    private String id;
    private T entity;
    private boolean isbatch;
    private List<T> entities;

    public UpdateEntityExecutor(RestHighLevelClientBulider client, T entity, Serializable id) {
        super(client);
        this.id = id.toString();
        this.entity = entity;
    }

    public UpdateEntityExecutor(RestHighLevelClientBulider client, T entity) {
        super(client);
        this.entity = entity;
    }

    public UpdateEntityExecutor(RestHighLevelClientBulider client, List<T> entities, boolean isbatch) {
        super(client);
        this.entities = entities;
        this.isbatch = isbatch;
    }

    @Override
    protected Object doExecute() throws ElasticsearchException {
        UpdateRequest updateRequest = new UpdateRequest();
        updateRequest.timeout(TimeValue.timeValueMinutes((long)this.requestRimeout));
        UpdateResponse updateResponse = null;
        BulkRequest bulkRequest = new BulkRequest();
        BulkResponse bulkResponse = null;
        LinkedList<Integer> entityList = new LinkedList<Integer>();
        PersistentEntity persistentEntity = null;
        if (this.entity != null) {
            persistentEntity = DynamicEntity.getPersistentEntityFor(this.entity.getClass());
            updateRequest.index(persistentEntity.getIndexName());
            updateRequest.type(persistentEntity.getIndexType());
            updateRequest.doc(JSON.toJSONString(this.entity), XContentType.JSON);
            if (Strings.isNotBlank(this.id)) {
                updateRequest.id(this.id);
            } else {
                String _id = Beans.getIdValue(this.entity);
                if (!Strings.isNotEmpty(_id)) {
                    throw new ElasticsearchException("@Id should be used for search id");
                }
                updateRequest.id(_id);
            }
        }
        if (Collects.isNotEmpty(this.entities)) {
            persistentEntity = DynamicEntity.getPersistentEntityFor(this.entities.get(0).getClass());
            for (T entity : this.entities) {
                updateRequest.index(persistentEntity.getIndexName());
                updateRequest.type(persistentEntity.getIndexType());
                String id = Beans.getIdValue(entity);
                updateRequest.id(id);
                updateRequest.doc(JSON.toJSONString(entity), XContentType.JSON);
                bulkRequest.add(updateRequest);
                try {
                    bulkResponse = this.client.bulk(bulkRequest, new Header[0]);
                    entityList.add(bulkResponse.status().getStatus());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            if (this.isbatch) {
                return entityList.size();
            }
            updateResponse = this.client.update(updateRequest, new Header[0]);
            return JSON.parseObject((String)ElasticsearchHelpper.toJsonWithId(JSON.toJSONString((Object)updateRequest.doc().sourceAsMap()), Beans.getIdName(this.entity.getClass()), updateResponse.getId()), this.entity.getClass());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

