/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.query;

import com.xphsc.elasticsearch.core.query.Criterion;
import com.xphsc.elasticsearch.core.query.SimpleExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.index.query.QueryBuilder;

public class QueryCondition
implements Criterion {
    private List<QueryBuilder> list = new ArrayList<QueryBuilder>();

    public QueryCondition equal(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.EQUAL).toBuilder());
        return this;
    }

    public QueryCondition notEqual(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.NOT_EQUAL).toBuilder());
        return this;
    }

    public QueryCondition orEqual(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.OR_EQUAL).toBuilder());
        return this;
    }

    public QueryCondition orNotEqual(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.OR_NOT_EQUAL).toBuilder());
        return this;
    }

    public QueryCondition equalAll(String field, Collection<Object> values) {
        this.list.add(new SimpleExpression(field, values).toBuilder());
        return this;
    }

    public QueryCondition match(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.MATCH).toBuilder());
        return this;
    }

    public QueryCondition orMatch(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.OR_MATCH).toBuilder());
        return this;
    }

    public QueryCondition notMatch(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.NOT_MATCH).toBuilder());
        return this;
    }

    public QueryCondition orNotMatch(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.OR_NOT_MATCH).toBuilder());
        return this;
    }

    public QueryCondition multiMatch(String[] field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.MULTI_MATCH).toBuilder());
        return this;
    }

    public QueryCondition like(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.LIKE).toBuilder());
        return this;
    }

    public QueryCondition notLike(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.NOT_LIKE).toBuilder());
        return this;
    }

    public QueryCondition orLike(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.OR_LIKE).toBuilder());
        return this;
    }

    public QueryCondition orNotLike(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.OR_NOT_LIKE).toBuilder());
        return this;
    }

    public QueryCondition moreLike(String[] field, Object ... value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.MORE_LIKE).toBuilder());
        return this;
    }

    public QueryCondition between(String field, Object from, Object to) {
        this.list.add(new SimpleExpression(field, from, to, Criterion.Operator.BETWEEN).toBuilder());
        return this;
    }

    public QueryCondition notBetween(String field, Object from, Object to) {
        this.list.add(new SimpleExpression(field, from, to, Criterion.Operator.NOT_BETWEEN).toBuilder());
        return this;
    }

    public QueryCondition orBetween(String field, Object from, Object to) {
        this.list.add(new SimpleExpression(field, from, to, Criterion.Operator.OR_BETWEEN).toBuilder());
        return this;
    }

    public QueryCondition orNotBetween(String field, Object from, Object to) {
        this.list.add(new SimpleExpression(field, from, to, Criterion.Operator.OR_NOT_BETWEEN).toBuilder());
        return this;
    }

    public QueryCondition in(String field, List<Object> values) {
        this.list.add(new SimpleExpression(Criterion.Operator.IN, field, values).toBuilder());
        return this;
    }

    public QueryCondition notIn(String field, List<Object> values) {
        this.list.add(new SimpleExpression(Criterion.Operator.NOT_IN, field, values).toBuilder());
        return this;
    }

    public QueryCondition orIn(String field, List<Object> values) {
        this.list.add(new SimpleExpression(Criterion.Operator.OR_IN, field, values).toBuilder());
        return this;
    }

    public QueryCondition orNotIn(String field, List<Object> values) {
        this.list.add(new SimpleExpression(Criterion.Operator.OR_NOR_IN, field, values).toBuilder());
        return this;
    }

    public QueryCondition in(List<Object> ids) {
        this.list.add(new SimpleExpression(Criterion.Operator.IN_IDS, ids).toBuilder());
        return this;
    }

    public QueryCondition notIn(List<Object> ids) {
        this.list.add(new SimpleExpression(Criterion.Operator.NOT_IN_IDS, ids).toBuilder());
        return this;
    }

    public QueryCondition orIn(List<Object> ids) {
        this.list.add(new SimpleExpression(Criterion.Operator.OR_IN_IDS, ids).toBuilder());
        return this;
    }

    public QueryCondition orNotIn(List<Object> ids) {
        this.list.add(new SimpleExpression(Criterion.Operator.OR_NOR_IN_IDS, ids).toBuilder());
        return this;
    }

    public QueryCondition greaterThan(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.GREATER_THAN).toBuilder());
        return this;
    }

    public QueryCondition orGreaterThan(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.OR_GREATER_THAN).toBuilder());
        return this;
    }

    public QueryCondition greaterThanEqual(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.GTE).toBuilder());
        return this;
    }

    public QueryCondition orGreaterThanEqual(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.OR_GTE).toBuilder());
        return this;
    }

    public QueryCondition lessThan(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.LT).toBuilder());
        return this;
    }

    public QueryCondition orLessThan(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.OR_LT).toBuilder());
        return this;
    }

    public QueryCondition lessThanEqual(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.LTE).toBuilder());
        return this;
    }

    public QueryCondition orLessThanEqual(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.OR_LTE).toBuilder());
        return this;
    }

    public QueryCondition prefix(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.PREFIX).toBuilder());
        return this;
    }

    public QueryCondition orPrefix(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.OR_PREFIX).toBuilder());
        return this;
    }

    public QueryCondition notPrefix(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.NOT_PREFIX).toBuilder());
        return this;
    }

    public QueryCondition orNotPrefix(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.OR_NOT_PREFIX).toBuilder());
        return this;
    }

    public QueryCondition regexp(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.REGEXP).toBuilder());
        return this;
    }

    public QueryCondition orRegexp(String field, Object value) {
        this.list.add(new SimpleExpression(field, value, Criterion.Operator.OR_REGEXP).toBuilder());
        return this;
    }

    public QueryCondition queryString(String queryString) {
        this.list.add(new SimpleExpression(queryString, Criterion.Operator.QUERY_STRING).toBuilder());
        return this;
    }

    public QueryCondition orQueryString(String queryString) {
        this.list.add(new SimpleExpression(queryString, Criterion.Operator.OR_QUERY_STRING).toBuilder());
        return this;
    }

    public QueryCondition isNotNull(String field) {
        this.list.add(new SimpleExpression(field, Criterion.Operator.IS_NOT_NULL).toBuilder());
        return this;
    }

    public QueryCondition orIsNotNull(String field) {
        this.list.add(new SimpleExpression(field, Criterion.Operator.OR_IS_NOT_NULL).toBuilder());
        return this;
    }

    public QueryCondition isNull(String field) {
        this.list.add(new SimpleExpression(field, Criterion.Operator.IS_NULL).toBuilder());
        return this;
    }

    public QueryCondition orIsNull(String field) {
        this.list.add(new SimpleExpression(field, Criterion.Operator.OR_IS_NULL).toBuilder());
        return this;
    }

    @Override
    public List<QueryBuilder> listBuilders() {
        return this.list;
    }
}

