/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.query;

import com.xphsc.elasticsearch.core.query.AggregateBuilder;
import com.xphsc.elasticsearch.core.query.Criterion;
import com.xphsc.elasticsearch.core.query.QueryCondition;
import com.xphsc.elasticsearch.page.Page;
import com.xphsc.elasticsearch.util.Asserts;
import com.xphsc.elasticsearch.util.Collects;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;

public class QueryCriteria {
    public String[] orderByAsc;
    public String[] orderBydesc;
    public Page pageQuery;
    public short queryMaxSize = (short)10000;
    public boolean isRefresh;
    public HighlightBuilder highlightBuilder;
    public List<Criterion> mustCriterions = new ArrayList<Criterion>();
    public AggregateBuilder aggregationCriteria;
    public String statBy;

    public QueryCriteria page(int pageNum, int pageSize) {
        if (this.pageQuery == null) {
            this.pageQuery = new Page();
        }
        Asserts.isTrue(pageNum >= 1, "PageNum must be greater than or equal to 1");
        Asserts.isTrue(pageSize > 0, "PageSize must be greater than 0");
        this.pageQuery.setPageNum(pageNum);
        this.pageQuery.setPageSize(pageSize);
        return this;
    }

    public QueryCriteria startPage(Integer start, Integer limit) {
        if (this.pageQuery == null) {
            this.pageQuery = new Page();
        }
        this.pageQuery.setOffset(start);
        this.pageQuery.setLimit(limit);
        return this;
    }

    public QueryCriteria queryMaxSize(short queryMaxSize) {
        this.queryMaxSize = queryMaxSize;
        return this;
    }

    public QueryCriteria orderByAsc(String[] orderByAsc) {
        this.orderByAsc = orderByAsc;
        return this;
    }

    public QueryCriteria orderBydesc(String[] orderBydesc) {
        this.orderBydesc = orderBydesc;
        return this;
    }

    public QueryCriteria isRefresh(boolean isRefresh) {
        this.isRefresh = isRefresh;
        return this;
    }

    public QueryCriteria highlightBuilder(HighlightBuilder highlightBuilder) {
        this.highlightBuilder = highlightBuilder;
        return this;
    }

    public QueryCriteria aggregationCriteria(AggregateBuilder aggregationCriteria) {
        this.aggregationCriteria = aggregationCriteria;
        return this;
    }

    public QueryCriteria statBy(String statBy) {
        this.statBy = statBy;
        return this;
    }

    public QueryBuilder listBuilders() {
        int count = this.mustCriterions.size();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        BoolQueryBuilder queryBuilder = null;
        if (count >= 1) {
            if (Collects.isNotEmpty(this.mustCriterions)) {
                for (Criterion criterion : this.mustCriterions) {
                    for (QueryBuilder builder : criterion.listBuilders()) {
                        queryBuilder = boolQueryBuilder.must(builder);
                    }
                }
            }
            return queryBuilder;
        }
        return null;
    }

    public Criteria createCriteria() {
        Criteria criteria = new Criteria();
        this.mustCriterions.add(criteria);
        return criteria;
    }

    public class AgggationCriteria
    extends AggregateBuilder {
    }

    public class Criteria
    extends QueryCondition {
    }
}

